/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.common.JMSDestinationInfo;
import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.JMSComponentBean;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseJMSCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Option;

public class ListJMSDestCommand
extends BaseJMSCommand {
    public ListJMSDestCommand() {
    }

    public ListJMSDestCommand(String string) {
        this.setName(string);
    }

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        try {
            JMSDestinationInfo[] jMSDestinationInfoArray;
            ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
            AppServerInstance appServerInstance = serverInstanceManager.getServerInstance(this.getInstanceOperand(0));
            JMSComponentBean jMSComponentBean = appServerInstance.getJMSComponent();
            String string = null;
            Option option = this.findOption("desttype");
            if (option != null) {
                string = option.getValue();
            }
            if ((jMSDestinationInfoArray = jMSComponentBean.getAllDestinations(string)) != null && jMSDestinationInfoArray.length > 0) {
                for (int i = 0; i < jMSDestinationInfoArray.length; ++i) {
                    this.printMessage(jMSDestinationInfoArray[i].toString());
                }
            } else {
                this.printMessage(this.getLocalizedString("NoJMSDestinations"));
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotListJMSDestinations"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }
}

