/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.JDBCResource;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseResourceCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;

public class ListJDBCResourcesCommand
extends BaseResourceCommand {
    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        try {
            ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
            AppServerInstance appServerInstance = serverInstanceManager.getServerInstance(this.getInstanceOperand(0));
            ServerModelIterator serverModelIterator = appServerInstance.getJDBCResources();
            if (serverModelIterator.hasNext()) {
                while (serverModelIterator.hasNext()) {
                    JDBCResource jDBCResource = (JDBCResource)serverModelIterator.next();
                    this.printMessage(jDBCResource);
                }
            } else {
                this.printMessage(this.getLocalizedString("NoJDBCResources"));
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotListJDBCResources"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }
}

