/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.AuthRealm;
import com.iplanet.ias.admin.servermodel.beans.SecurityServiceComponentBean;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseOtherCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;

public class ListAuthRealmsCommand
extends BaseOtherCommand {
    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        try {
            ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
            AppServerInstance appServerInstance = serverInstanceManager.getServerInstance(this.getInstanceOperand(0));
            SecurityServiceComponentBean securityServiceComponentBean = appServerInstance.getSecurityService();
            ServerModelIterator serverModelIterator = securityServiceComponentBean.getAuthRealms();
            if (serverModelIterator.hasNext()) {
                while (serverModelIterator.hasNext()) {
                    AuthRealm authRealm = (AuthRealm)serverModelIterator.next();
                    this.printMessage(authRealm);
                }
            } else {
                this.printMessage(this.getLocalizedString("NoAuthRealms"));
            }
            Debug.println(this.getClass().getName() + " : Command executed");
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotListAuthRealms"));
            throw new CommandException(exception.getLocalizedMessage());
        }
    }
}

