/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.ServerInstanceManagerFactory;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.ExceptionUtil;
import com.iplanet.ias.admin.util.HostAndPort;
import com.iplanet.ias.tools.cli.CLIHelpFileFinder;
import com.iplanet.ias.tools.cli.IasAdminGlobalsManager;
import com.iplanet.ias.tools.cli.PromptStream;
import com.iplanet.ias.tools.cli.XMLManReader;
import com.iplanet.ias.tools.cli.framework.CliUtil;
import com.iplanet.ias.tools.cli.framework.Command;
import com.iplanet.ias.tools.cli.framework.CommandEnvironment;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandFactory;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.GlobalsManager;
import com.iplanet.ias.tools.cli.framework.IUserInput;
import com.iplanet.ias.tools.cli.framework.InputsAndOutputs;
import com.iplanet.ias.tools.cli.framework.NoUserInput;
import com.iplanet.ias.tools.cli.framework.Operand;
import com.iplanet.ias.tools.cli.framework.Option;
import com.iplanet.ias.tools.cli.framework.UserInput;
import com.iplanet.ias.tools.cli.framework.ValidCommand;
import com.iplanet.ias.tools.cli.framework.ValidOption;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;

public abstract class IasCommand
extends Command {
    static String kPasswordOptionName = "password";
    static String kSessionStorePasswordOptionName = "storepassword";
    static String kSessionStoreSystemPasswordOptionName = "dbsystempassword";
    static String kPasswordFileOptionName = "passwordfile";
    static String kOptionsFileOptionName = "optionsfile";
    private static final String DEFAULT_INSTANCE = "server1";
    public static final String OPTION_VALUE_DELIMETER = "=";
    private static final String sEnvPrefix = "AS_ADMIN_";
    private static final String BAD = "=,/ &;`'\"|*!?~<>^()[]{}$\\:";

    public IasCommand() {
    }

    public IasCommand(String string, Vector vector, Vector vector2) {
        this.setName(string);
        this.setOptions(vector);
        this.setOperands(vector2);
    }

    private static void initGlobalsManager() {
        InputsAndOutputs inputsAndOutputs = new InputsAndOutputs();
        IasAdminGlobalsManager iasAdminGlobalsManager = new IasAdminGlobalsManager();
        IasAdminGlobalsManager.setInputsAndOutputs(inputsAndOutputs);
        CommandEnvironment commandEnvironment = new CommandEnvironment();
        iasAdminGlobalsManager.setGlobalsEnv(commandEnvironment);
        GlobalsManager.setInstance(iasAdminGlobalsManager);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean validateOptions() throws CommandValidationException {
        boolean bl = true;
        String string = null;
        if (this.isHelpProvided()) {
            bl = false;
            string = CLIHelpFileFinder.getCommandHelpFile(this.name);
            if (string != null) {
                XMLManReader xMLManReader = new XMLManReader(string, this.getUserOutput());
                return bl;
            }
            this.printMessage(this.helpStr);
        } else if (this.isEchoOn()) {
            this.echoCommand();
        }
        if (bl) {
            bl = super.validateOptions();
        }
        if (!bl) {
            this.printMessage(this.usageStr);
        } else if (this.isPasswordFileProvided()) {
            Debug.println("Password file option is provided **********");
            String string2 = this.findOption(kPasswordFileOptionName).getValue();
            bl = this.checkForFileExistence(string2);
            if (!bl) {
                throw new CommandValidationException(this.getLocalizedString("FileNotFound", new Object[]{string2}));
            }
            this.loadPasswordFile();
        }
        if (bl && this.isPasswordOptionRequired() && !this.isPasswordProvided()) {
            this.initPasswordOption();
        }
        return bl;
    }

    protected boolean checkForFileExistence(String string) {
        boolean bl = false;
        if (string == null) {
            return bl;
        }
        File file = new File(string);
        if (file.canRead()) {
            bl = true;
        }
        return bl;
    }

    protected void validatePosNumAttribute(String string, String string2) throws CommandValidationException {
        try {
            int n = Integer.valueOf(string);
            if (n < 0) {
                throw new CommandValidationException(this.getLocalizedString("NegativeValue") + ": " + string2);
            }
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue") + ": " + string2);
        }
    }

    public boolean isRequiredOptionsProvided() throws CommandValidationException {
        boolean bl = true;
        ValidCommand validCommand = CommandFactory.getValidCommand(this.name);
        Vector vector = validCommand.getRequiredOptions();
        for (int i = 0; i < vector.size(); ++i) {
            ValidOption validOption = (ValidOption)vector.get(i);
            if (validOption.getName().equals("password") && this.isInteractive() || this.hasOption(validOption)) continue;
            throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{validOption.getName()}));
        }
        return bl;
    }

    public void initUserInput() throws CommandValidationException {
        IUserInput iUserInput = null;
        iUserInput = this.isInteractive() ? new UserInput(System.in) : new NoUserInput(System.in);
        this.setUserInput(iUserInput);
    }

    public void initPasswordOption() throws CommandValidationException {
        Option option;
        IUserInput iUserInput = super.getUserInput();
        if (iUserInput != null && (option = super.getGlobalsMgr().getOption(kPasswordOptionName)) == null) {
            if (this.isInteractive()) {
                this.initPasswordOptionInteractively(kPasswordOptionName);
            } else {
                throw new CommandValidationException(this.getLocalizedString("CannotGetPassword"));
            }
        }
    }

    public void initSessionStorePasswordOption() throws CommandValidationException {
        Option option = super.getGlobalsMgr().getOption(kSessionStorePasswordOptionName);
        if (option == null) {
            if (this.isInteractive()) {
                this.initPasswordOptionInteractively(kSessionStorePasswordOptionName);
            } else {
                throw new CommandValidationException(this.getLocalizedString("CannotGetPassword"));
            }
        }
    }

    public void initSessionStoreSystemPasswordOption() throws CommandValidationException {
        Option option = super.getGlobalsMgr().getOption(kSessionStoreSystemPasswordOptionName);
        if (option == null) {
            if (this.isInteractive()) {
                this.initPasswordOptionInteractively(kSessionStoreSystemPasswordOptionName);
            } else {
                throw new CommandValidationException(this.getLocalizedString("CannotGetPassword"));
            }
        }
    }

    private void loadPasswordFile() throws CommandValidationException {
        BufferedReader bufferedReader = null;
        try {
            String string = kPasswordFileOptionName;
            Option option = this.findOption(string);
            String string2 = option.getValue();
            File file = new File(string2);
            bufferedReader = new BufferedReader(new FileReader(file));
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                Debug.println(string3);
                if (string3.regionMatches(true, 0, sEnvPrefix, 0, sEnvPrefix.length())) {
                    String string4 = string3.substring(sEnvPrefix.length());
                    int n = string4.indexOf(OPTION_VALUE_DELIMETER);
                    if (n == -1) {
                        throw new CommandValidationException(this.getLocalizedString("InvalidPasswordFileSyntax", new Object[]{string3}));
                    }
                    String string5 = string4.substring(0, n).toLowerCase();
                    String string6 = null;
                    if (n != string4.length()) {
                        string6 = string4.substring(n + 1, string4.length());
                    }
                    Debug.println(string5 + ":" + string6);
                    if (!(string5.equals("password") || string5.equals("adminpassword") || string5.equals("userpassword"))) {
                        throw new CommandValidationException(this.getLocalizedString("InvalidVariable", new Object[]{string5}));
                    }
                    GlobalsManager globalsManager = GlobalsManager.getInstance();
                    globalsManager.getLocalEnv().removeOption(string5);
                    globalsManager.setOption(new Option(string5, string6));
                }
                string3 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            Debug.println("Exception caught when reading the file");
            throw new CommandValidationException(exception.getLocalizedMessage());
        }
    }

    public void loadOptionsFile() throws CommandValidationException {
        BufferedReader bufferedReader = null;
        try {
            String string = kOptionsFileOptionName;
            Option option = this.findOption(string);
            String string2 = option.getValue();
            File file = new File(string2);
            bufferedReader = new BufferedReader(new FileReader(file));
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                Debug.println(string3);
                if (string3.regionMatches(true, 0, sEnvPrefix, 0, sEnvPrefix.length())) {
                    String string4 = string3.substring(sEnvPrefix.length());
                    String string5 = string4.toLowerCase();
                    int n = string5.indexOf(OPTION_VALUE_DELIMETER);
                    if (n == -1) {
                        throw new CommandValidationException(this.getLocalizedString("InvalidPasswordFileSyntax", new Object[]{string3}));
                    }
                    String string6 = string5.substring(0, n);
                    String string7 = null;
                    if (n != string5.length()) {
                        string7 = string5.substring(n + 1, string5.length());
                    }
                    Debug.println(string6 + ":" + string7);
                    GlobalsManager globalsManager = GlobalsManager.getInstance();
                    if (globalsManager.getOption(string6) == null) {
                        globalsManager.getLocalEnv().removeOption(string6);
                        globalsManager.setOption(new Option(string6, string7));
                    }
                }
                string3 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            Debug.println("Exception caught when reading the file");
            throw new CommandValidationException(exception.getLocalizedMessage());
        }
    }

    private void initPasswordOptionInteractively(String string) {
        String string2;
        Option option = this.findOption(string);
        try {
            CliUtil cliUtil = new CliUtil();
            this.printPrompt(string);
            string2 = cliUtil.getPassword();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string3 = unsatisfiedLinkError.getLocalizedMessage();
            if (string3 != null) {
                Debug.println(string3);
            }
            PromptStream promptStream = new PromptStream(System.in, System.out);
            string2 = promptStream.readln(string);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String string4 = noClassDefFoundError.getLocalizedMessage();
            if (string4 != null) {
                Debug.println(string4);
            }
            PromptStream promptStream = new PromptStream(System.in, System.out);
            string2 = promptStream.readln(string);
        }
        option = new Option(string);
        option.setValue(string2);
        this.addOption(option);
    }

    protected void printPrompt(String string) {
        byte[] byArray = (string + "> ").getBytes();
        try {
            System.out.write(byArray);
        }
        catch (IOException iOException) {
            ExceptionUtil.ignoreException(iOException);
            GlobalsManager.getInstance();
            GlobalsManager.getInputsAndOutputs().getUserOutput().println(iOException.getMessage());
        }
    }

    public boolean isSecure() {
        Option option = this.findOption("secure");
        if (option == null) {
            return false;
        }
        String string = option.getValue();
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("true");
    }

    public String getHost() throws CommandValidationException {
        Option option = this.findOption("host");
        if (option == null) {
            throw new CommandValidationException(this.getLocalizedString("HostOptionNotSpecified"));
        }
        return option.getValue();
    }

    public int getPort() throws CommandValidationException {
        String string = "";
        Option option = this.findOption("port");
        if (option == null) {
            throw new CommandValidationException(this.getLocalizedString("PortOptionNotSpecified"));
        }
        string = option.getValue();
        int n = 0;
        try {
            Debug.println("Port = '" + string + "'");
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            throw new CommandValidationException(this.getLocalizedString("InvalidPortNumber"));
        }
        return n;
    }

    public String getUser() throws CommandValidationException {
        Option option = this.findOption("user");
        if (option == null) {
            throw new CommandValidationException(this.getLocalizedString("UserOptionNotSpecified"));
        }
        return option.getValue();
    }

    public String getPassword() throws CommandValidationException {
        Option option = this.findOption("password");
        if (option == null) {
            throw new CommandValidationException(this.getLocalizedString("PasswordOptionNotSpecified"));
        }
        return option.getValue();
    }

    public boolean isHelpProvided() {
        boolean bl = false;
        Option option = this.findOption("help");
        if (option != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isEchoOn() throws CommandValidationException {
        boolean bl = false;
        Option option = this.findOption("echo");
        if (option == null) {
            throw new CommandValidationException(this.getLocalizedString("EchoNotProvided"));
        }
        String string = option.getValue();
        if (string.equalsIgnoreCase("true")) {
            bl = true;
        } else if (string.equalsIgnoreCase("false")) {
            bl = false;
        } else {
            throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue") + ": " + option.getName().toLowerCase());
        }
        return bl;
    }

    public String getInstanceOption() {
        String string = "";
        Option option = this.findOption("instance");
        string = option != null ? option.getValue() : DEFAULT_INSTANCE;
        return string;
    }

    public String getInstanceOperand(int n) {
        return ((Operand)this.getOperands().get(n)).getName();
    }

    public boolean isInteractive() throws CommandValidationException {
        boolean bl = false;
        Option option = this.findOption("interactive");
        if (option == null) {
            throw new CommandValidationException(this.getLocalizedString("InteractiveNotProvided"));
        }
        String string = option.getValue();
        if (string.equalsIgnoreCase("true")) {
            bl = true;
        } else if (string.equalsIgnoreCase("false")) {
            bl = false;
        } else {
            throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue") + ": " + option.getName().toLowerCase());
        }
        return bl;
    }

    public boolean isPasswordProvided() {
        return this.findOption(kPasswordOptionName) != null;
    }

    public boolean isPasswordFileProvided() {
        Debug.println("Checking if Password file option is provided **********");
        return this.findOption(kPasswordFileOptionName) != null;
    }

    public boolean isPasswordOptionRequired() {
        boolean bl = false;
        ValidCommand validCommand = CommandFactory.getValidCommand(this.name);
        Vector vector = validCommand.getRequiredOptions();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ValidOption validOption = (ValidOption)iterator.next();
            if (!validOption.getName().equalsIgnoreCase(kPasswordOptionName)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean shouldPrintPrompt() throws CommandValidationException {
        boolean bl = false;
        Option option = this.findOption("printprompt");
        if (option == null) {
            throw new CommandValidationException(this.getLocalizedString("PrintPromptNotProvided"));
        }
        String string = option.getValue();
        if (string.equalsIgnoreCase("true")) {
            bl = true;
        } else if (string.equalsIgnoreCase("false")) {
            bl = false;
        } else {
            throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue") + ": " + option.getName().toLowerCase());
        }
        return bl;
    }

    protected ServerInstanceManager getServerInstanceManager() throws CommandValidationException {
        HostAndPort hostAndPort = new HostAndPort(this.getHost(), this.getPort(), this.isSecure());
        ServerInstanceManagerFactory serverInstanceManagerFactory = ServerInstanceManagerFactory.getFactory();
        ServerInstanceManager serverInstanceManager = serverInstanceManagerFactory.getServerInstanceManager(hostAndPort, this.getUser(), this.getPassword());
        return serverInstanceManager;
    }

    public void runCommand() throws CommandException, CommandValidationException {
    }

    protected static void exceptionIfShellChar(String string) throws CommandException {
        int n = IasCommand.containsShellSpecificCharacter(string);
        if (n != -1) {
            throw new CommandException("\"" + string + "\" contains an invalid character: '" + (char)n + "'");
        }
    }

    protected static int containsShellSpecificCharacter(String string) {
        int n;
        for (n = 0; n < string.length() && BAD.indexOf(string.charAt(n)) == -1; ++n) {
        }
        return n < string.length() ? (int)string.charAt(n) : -1;
    }

    protected boolean isLocal() throws CommandValidationException {
        Option option = this.findOption("local");
        if (option != null && !option.isDefaultAssigned() && this.getBooleanOptionValue("local").equalsIgnoreCase("true")) {
            Debug.println("Running the local " + this.getName() + " command");
            return true;
        }
        Option option2 = this.findOption("host");
        if (option2 != null && !option2.isDefaultAssigned()) {
            return false;
        }
        Option option3 = this.findOption("port");
        if (option3 != null && !option3.isDefaultAssigned()) {
            return false;
        }
        Option option4 = this.findOption("password");
        if (option4 != null) {
            return false;
        }
        Option option5 = this.findOption("user");
        return option5 == null;
    }

    protected String getOptionValue(String string) {
        Option option = this.findOption(string);
        String string2 = null;
        if (option != null) {
            string2 = option.getValue();
        }
        return string2;
    }

    protected String getIntegerOptionValue(String string) throws CommandValidationException {
        Option option = this.findOption(string);
        if (option == null) {
            return null;
        }
        String string2 = option.getValue();
        this.validatePosNumAttribute(string2, string);
        return string2;
    }

    protected String getBooleanOptionValue(String string) throws CommandValidationException {
        Option option = this.findOption(string);
        if (option == null) {
            return null;
        }
        String string2 = null;
        if (option != null) {
            string2 = option.getValue();
        }
        boolean bl = false;
        if (string2 == null) {
            throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue") + ": " + option.getName().toLowerCase());
        }
        if (string2.equalsIgnoreCase("true")) {
            bl = true;
        } else if (string2.equalsIgnoreCase("false")) {
            bl = false;
        } else {
            throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue") + ": " + option.getName().toLowerCase());
        }
        return String.valueOf(bl);
    }
}

