/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.IasAdminGlobalsManager;
import com.iplanet.ias.tools.cli.framework.Command;
import com.iplanet.ias.tools.cli.framework.CommandEnvironment;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandLineParser;
import com.iplanet.ias.tools.cli.framework.CommandNotFoundException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.GlobalsManager;
import com.iplanet.ias.tools.cli.framework.InputsAndOutputs;
import com.iplanet.ias.tools.cli.framework.LocalizationException;
import java.util.StringTokenizer;

public class IasAdminMain {
    private static Command command = null;

    public static void invokeCLI(String string, InputsAndOutputs inputsAndOutputs) throws CommandException, CommandValidationException, CommandNotFoundException {
        String[] stringArray = IasAdminMain.convertLineToArgs(string);
        IasAdminMain.invokeCommand(stringArray, inputsAndOutputs);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        try {
            long l = System.currentTimeMillis();
            IasAdminMain.invokeCommand(stringArray, null);
            long l2 = System.currentTimeMillis();
            Debug.println("Time taken for the command is " + (l2 - l) + " milliseconds");
        }
        catch (LocalizationException localizationException) {
            System.out.println(localizationException.getLocalizedMessage());
            Debug.printStackTrace(localizationException);
            n = 1;
        }
        catch (CommandValidationException commandValidationException) {
            Debug.printStackTrace(commandValidationException);
            GlobalsManager.getInstance();
            InputsAndOutputs inputsAndOutputs = GlobalsManager.getInputsAndOutputs();
            inputsAndOutputs.getUserOutput().println(commandValidationException.getMessage());
            if (command != null) {
                inputsAndOutputs.getUserOutput().println(GlobalsManager.getLocalizedString("CommandNotExecuted", new Object[]{command.getName()}));
                inputsAndOutputs.getUserOutput().println(command.getUsage());
            }
            n = 1;
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            GlobalsManager.getInstance();
            InputsAndOutputs inputsAndOutputs = GlobalsManager.getInputsAndOutputs();
            inputsAndOutputs.getUserOutput().println(exception.getMessage());
            n = 1;
        }
        System.exit(n);
    }

    private static void invokeCommand(String[] stringArray, InputsAndOutputs inputsAndOutputs) throws CommandException, CommandValidationException, CommandNotFoundException {
        command = null;
        IasAdminMain.initializeCLI();
        IasAdminMain.initGlobalsManager(inputsAndOutputs);
        if (Debug.getEnabled()) {
            IasAdminMain.printArgs(stringArray);
        }
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new String[]{"multimode"};
        }
        CommandLineParser commandLineParser = new CommandLineParser(stringArray);
        command = commandLineParser.getCommand();
        command.runCommand();
    }

    public static Command getCommand() {
        return command;
    }

    private static String[] convertLineToArgs(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        String[] stringArray = null;
        stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)stringTokenizer.nextElement();
        }
        return stringArray;
    }

    private static void initializeCLI() {
        String string = System.getProperty("Debug");
        if (string != null) {
            Debug.setEnabled(true);
        } else {
            Debug.setEnabled(false);
        }
    }

    private static void initGlobalsManager(InputsAndOutputs inputsAndOutputs) {
        if (inputsAndOutputs == null) {
            inputsAndOutputs = new InputsAndOutputs();
        }
        IasAdminGlobalsManager iasAdminGlobalsManager = new IasAdminGlobalsManager();
        IasAdminGlobalsManager.setInputsAndOutputs(inputsAndOutputs);
        CommandEnvironment commandEnvironment = new CommandEnvironment();
        iasAdminGlobalsManager.setGlobalsEnv(commandEnvironment);
        GlobalsManager.setInstance(iasAdminGlobalsManager);
    }

    private static void printArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            Debug.println("argument[" + i + "] = " + stringArray[i]);
        }
    }
}

