/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseConfigurationCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Operand;
import com.iplanet.ias.tools.cli.framework.Option;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;

public class GetAttributeCommand
extends BaseConfigurationCommand {
    public boolean validateOptions() throws CommandValidationException {
        boolean bl = super.validateOptions();
        if (bl) {
            for (int i = 0; i < this.operands.size(); ++i) {
                Operand operand = (Operand)this.operands.get(i);
                if (operand.getValue() == null) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        Object object;
        Object object2;
        if (!this.validateOptions()) {
            return;
        }
        AttributeList attributeList = null;
        try {
            object2 = this.getServerInstanceManager();
            object = this.getAttributeNames();
            attributeList = this.isMonitoring() ? ((ServerInstanceManager)object2).getMonitorAttributes((String[])object) : ((ServerInstanceManager)object2).getGenericAttributes((String[])object);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotGetAttribute"));
            throw new CommandException(exception.getMessage());
        }
        if (attributeList == null) {
            this.printError(this.getLocalizedString("CannotGetAttribute"));
            throw new CommandException(this.getLocalizedString("NoAttributeNameMatch"));
        }
        try {
            object2 = attributeList.iterator();
            if (!object2.hasNext()) {
                this.printMessage(this.getLocalizedString("AttributeNotFound"));
            }
            while (object2.hasNext()) {
                object = (Attribute)object2.next();
                String string = "" + ((Attribute)object).getValue();
                if (string != null && string.equals("")) {
                    string = "\"\"";
                }
                this.printMessage(((Attribute)object).getName() + " = " + string);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotGetAttribute"));
            throw new CommandException(exception.getMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private String[] getAttributeNames() throws CommandValidationException {
        int n;
        Vector vector = new Vector();
        for (n = 0; n < this.operands.size(); ++n) {
            String string = ((Operand)this.operands.get(n)).getName();
            this.addAttribute(vector, string);
        }
        Debug.println("List of attribute names : ");
        for (n = 0; n < vector.size(); ++n) {
            Debug.println(vector.get(n));
        }
        return this.getElementsArray(vector);
    }

    private String[] getElementsArray(Vector vector) {
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        return stringArray;
    }

    private void addAttribute(Vector vector, String string) {
        String string2 = "";
        Option option = this.findOption("prefix");
        if (option != null) {
            string2 = option.getValue();
        }
        if (!string2.equals("")) {
            vector.add(string2 + "." + string);
        } else {
            vector.add(string);
        }
    }
}

