/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseEnvironmentCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandFactory;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.GlobalsManager;
import com.iplanet.ias.tools.cli.framework.ICommandEnvironment;
import com.iplanet.ias.tools.cli.framework.Operand;
import com.iplanet.ias.tools.cli.framework.Option;
import java.util.Iterator;

public class ExportCommand
extends BaseEnvironmentCommand {
    private static final char DOUBLE_QUOTE_CHAR = '\"';
    protected static final char ESCAPE_CHAR = '\\';
    protected static final String QUOTE_CHAR = "\"";
    private static final String sEnvPrefix = "AS_ADMIN_";

    public boolean validateOptions() throws CommandValidationException {
        boolean bl = super.validateOptions();
        if (!bl) {
            return bl;
        }
        for (int i = 0; i < this.operands.size(); ++i) {
            Operand operand = (Operand)this.operands.get(i);
            if ((operand = this.parseOperand(operand.getName())).getValue() != null) continue;
            throw new CommandValidationException(this.getLocalizedString("InvalidExportSyntax"));
        }
        return true;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        GlobalsManager globalsManager = GlobalsManager.getInstance();
        if (this.operands.size() == 0) {
            this.printEnvOptions(globalsManager);
            return;
        }
        for (int i = 0; i < this.operands.size(); ++i) {
            Operand operand = (Operand)this.operands.get(i);
            String string = (operand = this.parseOperand(operand.getName())).getName();
            if (string.regionMatches(true, 0, sEnvPrefix, 0, sEnvPrefix.length())) {
                String string2 = string.substring(sEnvPrefix.length());
                string = string2.toLowerCase();
                Debug.println(string + ":" + operand.getValue());
                if (CommandFactory.getOptionsList().getValidOption(string) == null) {
                    throw new CommandException(this.getLocalizedString("InvalidVariable", new Object[]{string}));
                }
                if (operand.getValue() == null) {
                    this.exportVariable(string);
                    continue;
                }
                globalsManager.getLocalEnv().removeOption(string);
                globalsManager.setOption(new Option(string, operand.getValue()));
                continue;
            }
            throw new CommandException(this.getLocalizedString("InvalidVariable", new Object[]{string}));
        }
    }

    private void printEnvOptions(GlobalsManager globalsManager) {
        ICommandEnvironment iCommandEnvironment = globalsManager.getGlobalsEnv();
        Iterator iterator = iCommandEnvironment.iterator();
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            String string = sEnvPrefix.concat(option.getName().toUpperCase());
            if (!(option.getName().equals("password") || option.getName().equals("adminpassword") || option.getName().equals("userpassword"))) {
                this.getUserOutput().println(string + " = " + option.getValue());
                continue;
            }
            this.getUserOutput().println(string + " = " + "********");
        }
    }

    private void exportVariable(String string) {
        GlobalsManager globalsManager = GlobalsManager.getInstance();
        Option option = globalsManager.getLocalEnv().findOption(string);
        if (option != null) {
            globalsManager.setOption(option);
            globalsManager.getLocalEnv().removeOption(string);
        }
    }

    private Operand parseOperand(String string) {
        Operand operand = new Operand();
        int n = this.getValueIndex(string);
        if (n == -1 || n == string.length()) {
            operand.setName(string);
            operand.setValue(null);
            return operand;
        }
        operand.setName(string.substring(0, n));
        operand.setValue(this.removeEscapeChars(string.substring(n + 1)));
        return operand;
    }

    private int getValueIndex(String string) {
        int n;
        int n2 = -1;
        boolean bl = false;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) == '\"') {
                if ((n = string.indexOf(34, n + 1)) == -1) {
                    return n;
                }
                if (string.length() != n) continue;
                return -1;
            }
            if (string.charAt(n) != '=' || string.charAt(n - 1) == '\\') continue;
            if (n == 0) {
                return -1;
            }
            return n;
        }
        return n;
    }

    private String removeEscapeChars(String string) {
        if (string.charAt(string.length() - 1) == '\"' && string.charAt(0) == '\"') {
            return string.substring(1, string.length() - 1);
        }
        int n = 0;
        String string2 = string;
        String string3 = "";
        while (n < string2.length()) {
            int n2 = string2.indexOf(String.valueOf('\\'), n);
            if (n2 == -1) {
                string3 = string3 + string2.substring(n);
                break;
            }
            string3 = string3 + string2.substring(n, n2);
            n = n2 + 1;
        }
        return string3;
    }
}

