/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.HttpServiceComponentBean;
import com.iplanet.ias.admin.servermodel.beans.VirtualServer;
import com.iplanet.ias.admin.servermodel.beans.VirtualServerClass;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseDeploymentCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Operand;
import com.iplanet.ias.tools.cli.framework.Option;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;

public class DeployCommand
extends BaseDeploymentCommand {
    private static final String CONTEXT_ROOT_OPTION = "contextroot";
    private static final String FORCE_DEPLOY_OPTION = "force";
    private static final String PRECOMPILE_JSP_OPTION = "precompilejsp";
    private static final String VERIFY_OPTION = "verify";
    private static final String UPLOAD_OPTION = "upload";
    private static final String COMPONENT_NAME = "name";
    private static final String DEPLOY_DIR = "deploydir";
    private static final String RETRIEVE_DIR = "retrieve";
    private static final String VIRTUAL_SERVERS = "virtualservers";
    private static final String VS_CLASS = "defaultclass";
    private static final String DELIMETER = ",";
    private static final String AVAILABILITY_OPTION = "availabilityenabled";

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        AppServerInstance appServerInstance;
        String string;
        if (!this.validateOptions()) {
            return;
        }
        try {
            string = ((Operand)this.getOperands().get(0)).getName();
            boolean bl = new Boolean(this.getBooleanOptionValue(UPLOAD_OPTION));
            if (!new File(string).exists() && bl) {
                throw new CommandValidationException(this.getLocalizedString("FileNotFoundOnLocalMachine"));
            }
            String string2 = this.getOptionValue(AVAILABILITY_OPTION);
            if (string2 != null && !string2.equals("true") && !string2.equals("false")) {
                throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue", new Object[]{AVAILABILITY_OPTION}));
            }
            ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
            appServerInstance = serverInstanceManager.getServerInstance(this.getInstanceOption());
            String string3 = this.getComponentName();
            Debug.println("Component name = " + string3);
            if (string3 == null || string3.equals("")) {
                throw new CommandValidationException(this.getLocalizedString("ComponentNameNull"));
            }
            boolean bl2 = new Boolean(this.getBooleanOptionValue(VERIFY_OPTION));
            String string4 = this.getType();
            if (string4 != null && this.findOption(CONTEXT_ROOT_OPTION) != null && !string4.equalsIgnoreCase("web")) {
                this.printMessage(this.getLocalizedString("InvalidContextRoot", new Object[]{string4}));
            }
            if (!(string4 == null || string4.equalsIgnoreCase("application") || string4.equalsIgnoreCase("web") || string4.equalsIgnoreCase("ejb") || string4.equalsIgnoreCase("connector"))) {
                throw new CommandValidationException(this.getLocalizedString("InvalidComponentType", new Object[]{string3, string4}));
            }
            if (string4.equalsIgnoreCase("application")) {
                String string5 = this.getVirtualServers(appServerInstance);
                boolean bl3 = new Boolean(this.getBooleanOptionValue(PRECOMPILE_JSP_OPTION));
                Debug.println("Virtual servers = " + string5);
                boolean bl4 = this.getName().equals(DEPLOY_DIR) ? appServerInstance.deployApplicationDirectory(string, string3, true, string5, this.isForceDeploy(), bl2, bl3, string2) : appServerInstance.deployApplication(string, string3, true, string5, this.isForceDeploy(), bl2, bl3, bl, string2);
                this.printMessage(this.getLocalizedString("DeployedApplication") + " " + string3);
                if (bl2) {
                    this.printMessage(this.getLocalizedString("VerifyLogLocationConsultAdminServerLog"));
                }
                if (!bl4) {
                    this.printMessage(this.getLocalizedString("CouldNotLoadApplication"));
                }
            } else if (string4.equalsIgnoreCase("web")) {
                String string6 = this.getVirtualServers(appServerInstance);
                boolean bl5 = new Boolean(this.getBooleanOptionValue(PRECOMPILE_JSP_OPTION));
                Debug.println("Virtual servers = " + string6);
                String string7 = this.getContextRoot();
                boolean bl6 = this.getName().equals(DEPLOY_DIR) ? appServerInstance.deployWarModuleDirectory(string, string3, string7, true, string6, this.isForceDeploy(), bl2, bl5, string2) : appServerInstance.deployWarModule(string, string3, string7, true, string6, this.isForceDeploy(), bl2, bl5, bl, string2);
                this.printMessage(this.getLocalizedString("DeployedWARModule") + " " + string3);
                if (bl2) {
                    this.printMessage(this.getLocalizedString("VerifyLogLocationConsultAdminServerLog"));
                }
                if (!bl6) {
                    this.printMessage(this.getLocalizedString("CouldNotLoadWARModule"));
                }
            } else if (string4.equalsIgnoreCase("ejb")) {
                boolean bl7 = this.getName().equals(DEPLOY_DIR) ? appServerInstance.deployEJBJarModuleDirectory(string, string3, this.isForceDeploy(), bl2, string2) : appServerInstance.deployEJBJarModule(string, string3, this.isForceDeploy(), bl2, bl, string2);
                this.printMessage(this.getLocalizedString("DeployedEJBModule") + " " + string3);
                if (bl2) {
                    this.printMessage(this.getLocalizedString("VerifyLogLocationConsultAdminServerLog"));
                }
                if (!bl7) {
                    this.printMessage(this.getLocalizedString("CouldNotLoadEJBModule"));
                }
            } else if (string4.equalsIgnoreCase("connector")) {
                boolean bl8 = this.getName().equals(DEPLOY_DIR) ? appServerInstance.deployConnectorModuleDirectory(string, string3, this.isForceDeploy(), bl2) : appServerInstance.deployConnectorModule(string, string3, this.isForceDeploy(), bl2, bl);
                this.printMessage(this.getLocalizedString("DeployedConnector") + " " + string3);
                if (bl2) {
                    this.printMessage(this.getLocalizedString("VerifyLogLocationConsultAdminServerLog"));
                }
                if (!bl8) {
                    this.printMessage(this.getLocalizedString("CouldNotLoadConnector"));
                }
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotDeployComponent"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        try {
            string = this.retrieveClientJAR(appServerInstance);
            if (string != null) {
                this.printMessage(this.getLocalizedString("RetrievedClientJAR") + string);
            }
        }
        catch (Exception exception) {
            this.printError(this.getLocalizedString("CannotRetrieveClientJAR"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private String getComponentName() {
        Option option = this.findOption(COMPONENT_NAME);
        String string = null;
        if (option != null) {
            string = option.getValue();
        }
        if (string == null) {
            string = this.getNameFromFilePath();
        }
        return string;
    }

    private String getNameFromFilePath() {
        String string = ((Operand)this.getOperands().get(0)).getName();
        String string2 = new File(string).getName();
        int n = string2.lastIndexOf(46);
        if (n < 0) {
            n = string2.length();
        }
        String string3 = string2.substring(0, n);
        return string3;
    }

    private String getType() {
        Option option = this.findOption("type");
        String string = null;
        if (option != null) {
            string = option.getValue();
        }
        if (string == null || string.equals("all")) {
            String string2 = ((Operand)this.getOperands().get(0)).getName();
            if (this.filePathIsDirectory()) {
                return "application";
            }
            int n = string2.lastIndexOf(46);
            String string3 = null;
            if (n >= 0) {
                string3 = string2.substring(n + 1);
            }
            if (string3 != null) {
                if (string3.equalsIgnoreCase("ear")) {
                    string = "application";
                } else if (string3.equalsIgnoreCase("war")) {
                    string = "web";
                } else if (string3.equalsIgnoreCase("jar")) {
                    string = "ejb";
                } else if (string3.equalsIgnoreCase("rar")) {
                    string = "connector";
                }
            } else {
                string = "application";
            }
        }
        return string;
    }

    private String getContextRoot() {
        Option option = this.findOption(CONTEXT_ROOT_OPTION);
        String string = null;
        if (option != null) {
            string = option.getValue();
        }
        if (string == null) {
            string = this.getNameFromFilePath();
        }
        return string;
    }

    private boolean isForceDeploy() throws CommandValidationException {
        Option option = this.findOption(FORCE_DEPLOY_OPTION);
        String string = null;
        if (option != null) {
            string = option.getValue();
        }
        boolean bl = false;
        if (string == null) {
            throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue") + ": " + option.getName().toLowerCase());
        }
        if (string.equalsIgnoreCase("true")) {
            bl = true;
        } else if (string.equalsIgnoreCase("false")) {
            bl = false;
        } else {
            throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue") + ": " + option.getName().toLowerCase());
        }
        return bl;
    }

    private boolean filePathIsDirectory() {
        String string = ((Operand)this.getOperands().get(0)).getName();
        return new File(string).isDirectory();
    }

    private String retrieveClientJAR(AppServerInstance appServerInstance) throws CommandException {
        Option option = this.findOption(RETRIEVE_DIR);
        if (option == null) {
            return null;
        }
        String string = this.getType();
        int n = 1001;
        if (string != null) {
            if (string.equalsIgnoreCase("application")) {
                n = 1001;
            } else if (string.equalsIgnoreCase("ejb")) {
                n = 1003;
            } else {
                throw new CommandException(this.getLocalizedString("CannotRetrieveClientJARForType"));
            }
        }
        try {
            String string2 = option.getValue();
            String string3 = appServerInstance.exportClientStubs(this.getComponentName(), n, string2);
            return string3;
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            throw new CommandException(exception.getLocalizedMessage());
        }
    }

    private String getVirtualServers(AppServerInstance appServerInstance) throws CommandValidationException, CommandException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Vector<String> vector = new Vector<String>();
        try {
            object4 = appServerInstance.getHttpService();
            object3 = ((HttpServiceComponentBean)object4).getVirtualServerClass(VS_CLASS);
            object2 = ((VirtualServerClass)object3).getVirtualServers();
            while (((ServerModelIterator)object2).hasNext()) {
                object = (VirtualServer)((ServerModelIterator)object2).next();
                vector.add(((VirtualServer)object).getVirtualServerId());
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            throw new CommandException(exception.getLocalizedMessage());
        }
        object4 = this.findOption(VIRTUAL_SERVERS);
        if (object4 != null && !((Option)object4).getValue().equals("")) {
            object3 = ((Option)object4).getValue();
            object2 = new Vector();
            object = new StringTokenizer((String)object3, DELIMETER);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken();
                if (((Vector)object2).contains(string)) {
                    throw new CommandValidationException(this.getLocalizedString("DuplicateVirtualServerID", new Object[]{string}));
                }
                if (!vector.contains(string)) {
                    throw new CommandException(this.getLocalizedString("InvalidVirtualServerID", new Object[]{string}));
                }
                ((Vector)object2).add(string);
            }
            return object3;
        }
        object3 = "";
        object2 = vector.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            object3 = (String)object3 + (String)object;
            if (!object2.hasNext()) continue;
            object3 = (String)object3 + DELIMETER;
        }
        return object3;
    }
}

