/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.installer.core.installConfig;
import com.iplanet.ias.tools.cli.BaseLifeCycleCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;

public class DeleteInstanceCommand
extends BaseLifeCycleCommand {
    private static final String ADMIN_SERVER = "admin-server";
    private static final String DOMAIN = "domain";

    public DeleteInstanceCommand() {
    }

    public DeleteInstanceCommand(String string) {
        this.setName(string);
    }

    public boolean validateOptions() throws CommandValidationException {
        boolean bl = super.validateOptions();
        if (!bl) {
            return bl;
        }
        if (this.isLocal()) {
            return true;
        }
        if (this.findOption("host") == null || this.findOption("port") == null || this.findOption("user") == null) {
            String string = null;
            string = this.findOption("host") == null ? "host" : (this.findOption("port") == null ? "port" : "user");
            throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{string}));
        }
        if (!this.isPasswordProvided()) {
            if (!this.isInteractive()) {
                throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{"password"}));
            }
            this.initPasswordOption();
        }
        return bl;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        String string = this.getInstanceOperand(0);
        if (this.isLocal()) {
            String string2 = this.getDomain();
            if (string.equals(ADMIN_SERVER)) {
                this.printError(this.getLocalizedString("CannotDeleteInstance"));
                throw new CommandException(this.getLocalizedString("CannotDeleteAdminInstance"));
            }
            if (!this.isInstanceExists(string2, string)) {
                this.printError(this.getLocalizedString("CannotDeleteInstance"));
                throw new CommandException(this.getLocalizedString("InstanceDoesNotExist", new Object[]{string}));
            }
            if (this.isInstanceAlreadyStarted(string2, string)) {
                this.printError(this.getLocalizedString("CannotDeleteInstance"));
                throw new CommandException(this.getLocalizedString("CannotDeleteRunningInstance", new Object[]{string}));
            }
            try {
                installConfig installConfig2 = new installConfig();
                installConfig2.deleteServerInstance(string, string2);
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                this.printError(this.getLocalizedString("CannotDeleteInstance"));
                throw new CommandException(exception.getLocalizedMessage());
            }
            this.printMessage(this.getLocalizedString("InstanceDeleted", new Object[]{string}));
        } else {
            try {
                ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
                boolean bl = serverInstanceManager.deleteServerInstance(string);
                String string3 = "";
                string3 = string3 + (bl ? this.getLocalizedString("InstanceDeleted", new Object[]{string}) : this.getLocalizedString("InstanceNotDeleted", new Object[]{string}));
                this.printMessage(string3);
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                this.printError(this.getLocalizedString("CannotDeleteInstance"));
                throw new CommandException(exception.getLocalizedMessage());
            }
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }
}

