/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseOtherCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Option;

public class DeleteIIOPClusterEndpointCommand
extends BaseOtherCommand {
    private static final String IIOP_SERVER_INSTANCE = "iiopserverinstance";
    private static final String IIOP_ENDPOINT_ID = "iiopendpointid";
    private String iiopServerInst = null;
    private String iiopEndpointId = null;

    public boolean validateOptions() throws CommandValidationException {
        if (!super.validateOptions()) {
            return false;
        }
        Option option = this.findOption(IIOP_SERVER_INSTANCE);
        Option option2 = this.findOption(IIOP_ENDPOINT_ID);
        if (option != null) {
            this.iiopServerInst = this.findOption(IIOP_SERVER_INSTANCE).getValue();
        }
        if (option2 != null) {
            this.iiopEndpointId = this.findOption(IIOP_ENDPOINT_ID).getValue();
        }
        if (option == null && option2 != null) {
            throw new CommandValidationException(this.getLocalizedString("SpecifyIIOPServerInstance"));
        }
        return true;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        AppServerInstance appServerInstance = null;
        boolean bl = false;
        if (!this.validateOptions()) {
            return;
        }
        try {
            if (this.iiopServerInst == null && this.iiopEndpointId == null && this.confirmBeforeContinue(this.getLocalizedString("AllEndpointsWillBeDeleted") + "\n" + this.getLocalizedString("ConfirmUserInput"))) {
                bl = true;
            } else {
                DeleteIIOPClusterEndpointCommand.exceptionIfShellChar(this.iiopServerInst);
            }
            ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
            appServerInstance = serverInstanceManager.getServerInstance(this.getInstanceOption());
            if (bl) {
                appServerInstance.deleteIIOPCluster();
            } else {
                appServerInstance.deleteIIOPEndpoint(this.iiopServerInst, this.iiopEndpointId);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotDeleteIIOPEndpoint"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        this.printMessage(this.getLocalizedString("DeletedIIOPEndpoint"));
        Debug.println(this.getClass().getName() + " : Command executed");
    }
}

