/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.HttpListener;
import com.iplanet.ias.admin.servermodel.beans.HttpServiceComponentBean;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseOtherCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Operand;

public class DeleteHttpListenerCommand
extends BaseOtherCommand {
    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        try {
            HttpListener httpListener;
            ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
            String string = ((Operand)this.getOperands().get(0)).getName();
            AppServerInstance appServerInstance = serverInstanceManager.getServerInstance(this.getInstanceOption());
            HttpServiceComponentBean httpServiceComponentBean = appServerInstance.getHttpService();
            ServerModelIterator serverModelIterator = httpServiceComponentBean.getHttpListeners();
            if (serverModelIterator.hasNext() && (httpListener = (HttpListener)serverModelIterator.next()).getDisplayName().equals(string) && !serverModelIterator.hasNext()) {
                throw new CommandException(this.getLocalizedString("CannotDeleteAllHttpListeners", new Object[]{string}));
            }
            httpServiceComponentBean.deleteHttpListener(string);
            this.printMessage(this.getLocalizedString("DeletedHttpListener", new Object[]{string}));
            Debug.println(this.getClass().getName() + " : Command executed");
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotDeleteHttpListener"));
            throw new CommandException(exception.getLocalizedMessage());
        }
    }
}

