/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseOtherCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.util.sessionstore.HADBSessionStoreUtil;
import com.iplanet.ias.tools.cli.util.sessionstore.SessionStoreException;

public class CreateSessionStoreCommand
extends BaseOtherCommand {
    private static String storeUserName = "storeuser";
    private static String storePasswordName = "storepassword";
    private static String storeUrlName = "storeurl";
    private static String optionsFileName = "optionsfile";
    private static String systemPasswordName = "dbsystempassword";

    public boolean validateOptions() throws CommandValidationException {
        String string = null;
        if (!super.validateOptions()) {
            return false;
        }
        if (this.findOption(optionsFileName) != null) {
            this.loadOptionsFile();
        }
        if (this.findOption(storeUrlName) == null || this.findOption(storeUserName) == null) {
            if (this.findOption(storeUrlName) == null) {
                string = storeUrlName;
            } else if (this.findOption(storeUserName) == null) {
                string = storeUserName;
            }
            throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{string}));
        }
        if (this.findOption(storePasswordName) == null) {
            if (!this.isInteractive()) {
                throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{storePasswordName}));
            }
            this.initSessionStorePasswordOption();
        }
        if (this.findOption(systemPasswordName) == null) {
            if (!this.isInteractive()) {
                throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{systemPasswordName}));
            }
            this.initSessionStoreSystemPasswordOption();
        }
        if (this.findOption(storeUserName) != null && this.findOption(storeUserName).getValue().equals("system")) {
            throw new CommandValidationException(this.getLocalizedString("StoreUserSystemCannotOverride"));
        }
        return true;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        try {
            HADBSessionStoreUtil hADBSessionStoreUtil = null;
            hADBSessionStoreUtil = new HADBSessionStoreUtil(this.findOption(storeUserName).getValue(), this.findOption(storePasswordName).getValue(), this.findOption(storeUrlName).getValue(), this.findOption(systemPasswordName).getValue());
            hADBSessionStoreUtil.createSessionStore();
            this.printMessage(this.getLocalizedString("CreatedSessionStore"));
        }
        catch (SessionStoreException sessionStoreException) {
            Debug.printStackTrace(sessionStoreException);
            throw new CommandException(sessionStoreException.toString());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }
}

