/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.HttpListener;
import com.iplanet.ias.admin.servermodel.beans.HttpServiceComponentBean;
import com.iplanet.ias.admin.servermodel.beans.IiopListener;
import com.iplanet.ias.admin.servermodel.beans.ORBComponentBean;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseOtherCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Operand;
import com.iplanet.ias.tools.cli.framework.Option;
import java.util.Iterator;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;

public class CreateSSLCommand
extends BaseOtherCommand {
    private static final String ADMIN_SERVER = "admin-server";
    private static final String SSL2_ENABLED = "ssl2enabled";
    private static final String SSL2_CIPHERS = "ssl2ciphers";
    private static final String SSL3_ENABLED = "ssl3enabled";
    private static final String SSL3_TLS_CIPHERS = "ssl3tlsciphers";
    private static final String TLS_ENABLED = "tlsenabled";
    private static final String TLS_ROLLBACK_ENABLED = "tlsrollbackenabled";
    private static final String CLIENT_AUTH_ENABLED = "clientauthenabled";
    private static final String HTTP_LISTENER = "http-listener";
    private static final String IIOP_LISTENER = "iiop-listener";
    private static final String IIOP_SERVICE = "iiop-service";

    public boolean validateOptions() throws CommandValidationException {
        if (!super.validateOptions()) {
            return false;
        }
        Option option = this.findOption("type");
        if (option != null && option.getValue().equals("all")) {
            throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{option.getName()}));
        }
        String string = option.getValue();
        if (!string.equals(HTTP_LISTENER)) {
            if (this.getInstanceOption().equals(ADMIN_SERVER)) {
                throw new CommandValidationException(this.getLocalizedString("InvalidAdminListenerType"));
            }
            if (!string.equals(IIOP_LISTENER) && !string.equals(IIOP_SERVICE)) {
                throw new CommandValidationException(this.getLocalizedString("InvalidListenerType"));
            }
        }
        if (string.equals(HTTP_LISTENER) || string.equals(IIOP_LISTENER) ? this.getOperands().size() != 1 : string.equals(IIOP_SERVICE) && this.getOperands().size() != 0) {
            throw new CommandValidationException(this.getLocalizedString("InvalidNumberOfOperands"));
        }
        return true;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        String string;
        Object object;
        AppServerInstance appServerInstance = null;
        if (!this.validateOptions()) {
            return;
        }
        try {
            object = this.getServerInstanceManager();
            string = this.getInstanceOption();
            appServerInstance = string.equals(ADMIN_SERVER) ? ((ServerInstanceManager)object).getAdminInstance() : ((ServerInstanceManager)object).getServerInstance(this.getInstanceOption());
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotCreateSSL"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        object = this.findOption("type");
        string = ((Option)object).getValue();
        String string2 = this.findOption("certname").getValue();
        try {
            if (string.equals(HTTP_LISTENER)) {
                this.createSSLInHTTPListener(appServerInstance, string2);
                this.printMessage(this.getLocalizedString("CreatedSSLInHTTPListener"));
            } else if (string.equals(IIOP_LISTENER)) {
                this.createSSLInIIOPListener(appServerInstance, string2);
                this.printMessage(this.getLocalizedString("CreatedSSLInIIOPListener"));
            } else if (string.equals(IIOP_SERVICE)) {
                this.createSSLInIIOPService(appServerInstance, string2);
                this.printMessage(this.getLocalizedString("CreatedSSLInIIOPService"));
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private AttributeList getAttributeList() throws CommandValidationException {
        Attribute attribute;
        Object object;
        AttributeList attributeList = new AttributeList();
        if (this.findOption(SSL2_ENABLED) != null) {
            object = new Attribute("ssl2", this.getBooleanOptionValue(SSL2_ENABLED));
            attributeList.add((Attribute)object);
        }
        if (this.findOption(SSL2_CIPHERS) != null) {
            object = this.getOptionValue(SSL2_CIPHERS);
            this.isValidSSL2Ciphers((String)object);
            attribute = new Attribute("ssl2Ciphers", object);
            attributeList.add(attribute);
        }
        if (this.findOption(SSL3_ENABLED) != null) {
            object = new Attribute("ssl3", this.getBooleanOptionValue(SSL3_ENABLED));
            attributeList.add((Attribute)object);
        }
        if (this.findOption(SSL3_TLS_CIPHERS) != null) {
            object = this.getOptionValue(SSL3_TLS_CIPHERS);
            this.isValidSSL3Ciphers((String)object);
            attribute = new Attribute("ssl3Ciphers", object);
            attributeList.add(attribute);
        }
        if (this.findOption(TLS_ENABLED) != null) {
            object = new Attribute("tls", this.getBooleanOptionValue(TLS_ENABLED));
            attributeList.add((Attribute)object);
        }
        if (this.findOption(TLS_ROLLBACK_ENABLED) != null) {
            object = new Attribute("tlsRollback", this.getBooleanOptionValue(TLS_ROLLBACK_ENABLED));
            attributeList.add((Attribute)object);
        }
        if (this.findOption(CLIENT_AUTH_ENABLED) != null) {
            object = new Attribute("clientAuth", this.getBooleanOptionValue(CLIENT_AUTH_ENABLED));
            attributeList.add((Attribute)object);
        }
        return attributeList;
    }

    private void isValidSSL2Ciphers(String string) throws CommandValidationException {
        Iterator iterator = this.getCiphers(string);
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.equals("rc4") || string2.equals("rc4export") || string2.equals("rc2") || string2.equals("rc2export") || string2.equals("idea") || string2.equals("des") || string2.equals("desede3")) continue;
            throw new CommandValidationException(this.getLocalizedString("InvalidSSL2Ciphers"));
        }
    }

    private void isValidSSL3Ciphers(String string) throws CommandValidationException {
        Iterator iterator = this.getCiphers(string);
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.equals("rsa_rc4_128_md5") || string2.equals("rsa_3des_sha") || string2.equals("rsa3des_sha") || string2.equals("rsa_des_sha") || string2.equals("rsa_rc4_40_md5") || string2.equals("rsa_rc2_40_md5") || string2.equals("rsa_null_md5") || string2.equals("rsa_des_56_sha") || string2.equals("rsa_rc4_56_sha")) continue;
            throw new CommandValidationException(this.getLocalizedString("InvalidSSL3Ciphers"));
        }
    }

    private Iterator getCiphers(String string) throws CommandValidationException {
        int n = 0;
        Vector<String> vector = new Vector<String>();
        while (n < string.length()) {
            int n2 = string.indexOf(44, n);
            if (n2 == -1) {
                n2 = string.length();
            }
            if (string.charAt(n) == '+' || string.charAt(n) == '-') {
                if (n < n2) {
                    ++n;
                } else {
                    throw new CommandValidationException(this.getLocalizedString("InvalidSSLCiphers"));
                }
            }
            String string2 = string.substring(n, n2);
            n = n2 + 1;
            vector.add(string2);
        }
        return vector.iterator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createSSLInHTTPListener(AppServerInstance appServerInstance, String string) throws Exception {
        String string2 = ((Operand)this.getOperands().get(0)).getName();
        HttpServiceComponentBean httpServiceComponentBean = appServerInstance.getHttpService();
        HttpListener httpListener = httpServiceComponentBean.getHttpListener(string2);
        if (httpListener.isSSLCreated()) throw new CommandException(this.getLocalizedString("SSLExists"));
        AttributeList attributeList = null;
        try {
            attributeList = this.getAttributeList();
            httpListener.createSSL(string);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotCreateSSLInHTTPListener"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        try {
            if (attributeList == null || attributeList.isEmpty()) return;
            AttributeList attributeList2 = httpListener.setAttributes(attributeList);
            this.validateAttributeList(attributeList, attributeList2);
            return;
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("UseDefaultAttribute"));
            throw new CommandException(exception.getLocalizedMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createSSLInIIOPListener(AppServerInstance appServerInstance, String string) throws Exception {
        String string2 = ((Operand)this.getOperands().get(0)).getName();
        ORBComponentBean oRBComponentBean = appServerInstance.getORBComponent();
        IiopListener iiopListener = oRBComponentBean.getIiopListener(string2);
        if (iiopListener.isSSLCreated()) throw new CommandException(this.getLocalizedString("SSLExists"));
        AttributeList attributeList = null;
        try {
            attributeList = this.getAttributeList();
            iiopListener.createSSL(string);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotCreateSSLInIIOPListener"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        try {
            if (attributeList == null || attributeList.isEmpty()) return;
            AttributeList attributeList2 = iiopListener.setAttributes(attributeList);
            this.validateAttributeList(attributeList, attributeList2);
            return;
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("UseDefaultAttribute"));
            throw new CommandException(exception.getLocalizedMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createSSLInIIOPService(AppServerInstance appServerInstance, String string) throws Exception {
        ORBComponentBean oRBComponentBean = appServerInstance.getORBComponent();
        if (oRBComponentBean.isSSLCreated()) throw new CommandException(this.getLocalizedString("SSLExists"));
        AttributeList attributeList = null;
        try {
            attributeList = this.getAttributeList();
            oRBComponentBean.createSSL(string);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotCreateSSLInIIOPService"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        try {
            if (attributeList == null || attributeList.isEmpty()) return;
            AttributeList attributeList2 = oRBComponentBean.setAttributes(attributeList);
            this.validateAttributeList(attributeList, attributeList2);
            return;
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("UseDefaultAttribute"));
            throw new CommandException(exception.getLocalizedMessage());
        }
    }
}

