/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.HostAndPort;
import com.iplanet.ias.installer.core.ServerConfig;
import com.iplanet.ias.installer.core.installConfig;
import com.iplanet.ias.license.IASLicense;
import com.iplanet.ias.tools.cli.BaseLifeCycleCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.util.net.NetUtils;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class CreateInstanceCommand
extends BaseLifeCycleCommand {
    private static final String HOST = "host";
    private static final String ADMIN_PORT = "port";
    private static final String ADMIN_USER = "user";
    private static final String ADMIN_PASSWD = "password";
    private static final String DOMAIN = "domain";
    private static final String ADMIN_ID = "admin-server";
    private static final String DOCROOT = "docroot";
    private static final String INSTANCE_PORT = "instanceport";
    private static final String SYS_USER = "sysuser";

    public CreateInstanceCommand() {
    }

    public CreateInstanceCommand(String string) {
        this.setName(string);
    }

    public boolean validateOptions() throws CommandValidationException {
        boolean bl = super.validateOptions();
        if (!bl) {
            return bl;
        }
        if (this.isLocal()) {
            return true;
        }
        if (this.findOption(HOST) == null || this.findOption(ADMIN_PORT) == null || this.findOption(ADMIN_USER) == null) {
            String string = null;
            string = this.findOption(HOST) == null ? HOST : (this.findOption(ADMIN_PORT) == null ? ADMIN_PORT : ADMIN_USER);
            throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{string}));
        }
        if (!this.isPasswordProvided()) {
            if (!this.isInteractive()) {
                throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{ADMIN_PASSWD}));
            }
            this.initPasswordOption();
        }
        return bl;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        String string = this.getInstanceOperand(0);
        String string2 = this.getOptionValue(SYS_USER);
        if (this.isLocal()) {
            try {
                CreateInstanceCommand.exceptionIfShellChar(string);
                this.unsetLicenseLogger();
                IASLicense.checkCurrent((boolean)false);
                String string3 = this.getDomain();
                String string4 = this.getDomainLocation(string3);
                IASLicense.checkCanCreateInstance((int)this.getInstanceCount(new File(string4), false));
                if (this.isInstanceExists(this.getDomain(), string)) {
                    throw new CommandValidationException(this.getLocalizedString("InstanceAlreadyExists", new Object[]{string}));
                }
                if (this.getInstancePort() <= 0) {
                    throw new CommandValidationException(this.getLocalizedString("InvalidPortSpecified", new Object[]{this.getOptionValue(INSTANCE_PORT)}));
                }
                ServerConfig serverConfig = new ServerConfig();
                File file = new File(System.getProperty("com.sun.aas.installRoot"));
                File file2 = new File(System.getProperty("com.sun.aas.javaRoot"));
                File file3 = new File(System.getProperty("com.sun.aas.imqBin"));
                File file4 = new File(System.getProperty("com.sun.aas.imqLib"));
                String[] stringArray = new String[]{string4, ADMIN_ID, DOCROOT};
                String string5 = StringUtils.makeFilePath(stringArray, false);
                serverConfig.serverID = string;
                serverConfig.serverPort = this.getInstancePort();
                serverConfig.serverName = this.createLocalHostName();
                serverConfig.serverUser = string2 == null ? System.getProperty("user.name") : string2;
                serverConfig.docRoot = FileUtils.makeForwardSlashes(string5);
                serverConfig.javaHome = FileUtils.makeForwardSlashes(file2.getAbsolutePath());
                serverConfig.imqBin = FileUtils.makeForwardSlashes(file3.getAbsolutePath());
                serverConfig.imqLib = FileUtils.makeForwardSlashes(file4.getAbsolutePath());
                serverConfig.serverRoot = FileUtils.makeForwardSlashes(file.getAbsolutePath());
                serverConfig.domainRoot = FileUtils.makeForwardSlashes(string4);
                serverConfig.domainName = string3;
                serverConfig.orbListenerPort = NetUtils.getFreePort();
                serverConfig.jmsPort = NetUtils.getFreePort();
                serverConfig.configRoot = System.getProperty("com.sun.aas.configRoot");
                Debug.println(serverConfig);
                installConfig installConfig2 = new installConfig();
                String string6 = installConfig2.createServerInstance(serverConfig);
                if (string6 != null) {
                    throw new CommandException(string6);
                }
                this.printMessage(this.getLocalizedString("InstanceCreated", new Object[]{string}));
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                Debug.println("Create Instance in Domain, Exception caught ");
                this.printError(this.getLocalizedString("CannotCreateInstance"));
                throw new CommandException(exception.getLocalizedMessage());
            }
        }
        try {
            HostAndPort hostAndPort = new HostAndPort(this.getHost(), this.getInstancePort());
            ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
            AppServerInstance appServerInstance = serverInstanceManager.createServerInstance(hostAndPort, string, string2);
            String string7 = "";
            string7 = string7 + (appServerInstance != null ? this.getLocalizedString("InstanceCreated", new Object[]{string}) : this.getLocalizedString("InstanceNotCreated", new Object[]{string}));
            this.printMessage(string7);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotCreateInstance"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private int getInstancePort() throws CommandValidationException {
        String string = "";
        string = this.getOptionValue(INSTANCE_PORT);
        return this.convertPortStr(string);
    }

    private int convertPortStr(String string) throws CommandValidationException {
        int n = 0;
        try {
            Debug.println("Port = '" + string + "'");
            n = Integer.parseInt(string);
            return n;
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            throw new CommandValidationException(this.getLocalizedString("InvalidPortNumber"));
        }
    }

    private String createLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "localhost";
        }
    }
}

