/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.common.constant.ConfigAttributeName;
import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.ServiceComponentBean;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseOtherCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Option;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;

public class ConfigureSessionPersistenceCommand
extends BaseOtherCommand
implements ConfigAttributeName.SessionPersistence,
ConfigAttributeName.SessionManager {
    public static final String PREFIX = "property.";
    public static final String PERSISTENCE_TYPE_PROPERTY = "persistenceType";
    public static final String FREQUENCY_PROPERTY = "property.persistenceFrequency";
    public static final String SCOPE_PROPERTY = "property.persistenceScope";
    public static final String STORE_PROPERTY = "property.store-pool-jndi-name";
    public static final String PERSISTENCE_TYPE_OPTION = "type";
    public static final String FREQUENCY_OPTION = "frequency";
    public static final String SCOPE_OPTION = "scope";
    public static final String PERSISTENT_STORE_OPTION = "store";
    private String persistenceType = null;

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        Serializable serializable;
        if (!this.validateOptions()) {
            return;
        }
        this.persistenceType = this.getPersistenceTypeOption();
        String string = this.getFrequencyOption();
        String string2 = this.getScopeOption();
        String string3 = this.getStoreOption();
        AttributeList attributeList = this.getAttributeList();
        String string4 = this.getInstanceOperand(0);
        ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
        try {
            serializable = serverInstanceManager.getServerInstance(string4);
            ServiceComponentBean serviceComponentBean = null;
            if (this.persistenceType != null) {
                serviceComponentBean = ((AppServerInstance)serializable).getSessionManager();
                serviceComponentBean.setAttribute(PERSISTENCE_TYPE_PROPERTY, this.persistenceType);
            }
            if (string != null) {
                serviceComponentBean = ((AppServerInstance)serializable).getManagerProperties();
                serviceComponentBean.setAttribute(FREQUENCY_PROPERTY, string);
            }
            if (string2 != null) {
                serviceComponentBean = ((AppServerInstance)serializable).getStoreProperties();
                serviceComponentBean.setAttribute(SCOPE_PROPERTY, string2);
            }
            if (string3 != null) {
                serviceComponentBean = ((AppServerInstance)serializable).getPersistenceStore();
                serviceComponentBean.setAttribute(STORE_PROPERTY, string3);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotConfigureSessionPersistence"));
            throw new CommandException(exception.getMessage());
        }
        if (attributeList != null && attributeList.size() > 0) {
            serializable = null;
            try {
                serializable = serverInstanceManager.setGenericAttributes(attributeList);
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                this.printError(this.getLocalizedString("CannotSetProperty"));
                throw new CommandException(exception.getMessage());
            }
            if (serializable == null || ((ArrayList)serializable).size() < attributeList.size()) {
                throw new CommandException(this.getLocalizedString("CannotSetProperty"));
            }
        }
        this.printMessage(this.getLocalizedString("ConfiguredSessionPersistence", new Object[]{string4, string, string2, string3}));
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private String getPersistenceTypeOption() throws CommandValidationException {
        String string;
        Option option = this.findOption(PERSISTENCE_TYPE_OPTION);
        String string2 = string = option != null ? option.getValue() : null;
        if (string == null || string.equals("") || string.equals("all")) {
            return "memory";
        }
        if (!(string.equals("memory") || string.equals("file") || string.equals("ha"))) {
            throw new CommandValidationException(this.getLocalizedString("UnsupportedPersistenceParameter", new Object[]{PERSISTENCE_TYPE_OPTION, string}));
        }
        return string;
    }

    private String getFrequencyOption() throws CommandValidationException {
        String string;
        Option option = this.findOption(FREQUENCY_OPTION);
        String string2 = string = option != null ? option.getValue() : null;
        if (string == null || string.equals("")) {
            return this.persistenceType.equals("ha") ? "web-method" : null;
        }
        if (!this.persistenceType.equals("ha")) {
            throw new CommandValidationException(this.getLocalizedString("FrequencyOptionUnsupported", new Object[]{this.persistenceType}));
        }
        if (!string.equals("web-method") && !string.equals("time-based")) {
            throw new CommandValidationException(this.getLocalizedString("UnsupportedPersistenceParameter", new Object[]{FREQUENCY_OPTION, string}));
        }
        return string;
    }

    private String getScopeOption() throws CommandValidationException {
        String string;
        Option option = this.findOption(SCOPE_OPTION);
        String string2 = string = option != null ? option.getValue() : null;
        if (string == null || string.equals("")) {
            return this.persistenceType.equals("ha") ? "session" : null;
        }
        if (!this.persistenceType.equals("ha")) {
            throw new CommandValidationException(this.getLocalizedString("ScopeOptionUnsupported", new Object[]{this.persistenceType}));
        }
        if (!(string.equals("session") || string.equals("modified-session") || string.equals("modified-attribute"))) {
            throw new CommandValidationException(this.getLocalizedString("UnsupportedPersistenceParameter", new Object[]{SCOPE_OPTION, string}));
        }
        return string;
    }

    private String getStoreOption() throws CommandValidationException {
        String string;
        Option option = this.findOption(PERSISTENT_STORE_OPTION);
        String string2 = string = option != null ? option.getValue() : null;
        if (string == null || string.equals("")) {
            return null;
        }
        if (!this.persistenceType.equals("ha")) {
            throw new CommandValidationException(this.getLocalizedString("StoreOptionUnsupported", new Object[]{this.persistenceType}));
        }
        return string;
    }

    private AttributeList getAttributeList() throws CommandValidationException {
        AttributeList attributeList = new AttributeList();
        Properties properties = this.getProperties();
        if (!properties.isEmpty()) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)properties.get(string);
                Attribute attribute = new Attribute(string, string2);
                attributeList.add(attribute);
                Debug.println("Property(name,value) = " + string + " , " + string2);
            }
        }
        return attributeList;
    }
}

