/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseOtherCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.util.sessionstore.HADBSessionStoreUtil;
import com.iplanet.ias.tools.cli.util.sessionstore.SessionStoreException;

public class ClearSessionStoreCommand
extends BaseOtherCommand {
    private static String storeUserName = "storeuser";
    private static String storePasswordName = "storepassword";
    private static String storeUrlName = "storeurl";
    private static String optionsFileName = "optionsfile";

    public boolean validateOptions() throws CommandValidationException {
        String string = null;
        if (!super.validateOptions()) {
            return false;
        }
        if (this.findOption(optionsFileName) != null) {
            this.loadOptionsFile();
        }
        if (this.findOption(storeUrlName) == null || this.findOption(storeUserName) == null) {
            if (this.findOption(storeUrlName) == null) {
                string = storeUrlName;
            } else if (this.findOption(storeUserName) == null) {
                string = storeUserName;
            }
            throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{string}));
        }
        if (this.findOption(storePasswordName) == null) {
            if (!this.isInteractive()) {
                throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{"storepassword"}));
            }
            this.initSessionStorePasswordOption();
        }
        return true;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        if (this.confirmBeforeContinue(this.getLocalizedString("AllSessionsWillBeDeleted") + "\n" + this.getLocalizedString("ConfirmUserInput"))) {
            try {
                HADBSessionStoreUtil hADBSessionStoreUtil = new HADBSessionStoreUtil(this.findOption(storeUserName).getValue(), this.findOption(storePasswordName).getValue(), this.findOption(storeUrlName).getValue());
                hADBSessionStoreUtil.clearSessionStore();
                this.printMessage(this.getLocalizedString("ClearedSessionStore"));
            }
            catch (SessionStoreException sessionStoreException) {
                Debug.printStackTrace(sessionStoreException);
                String string = null;
                string = sessionStoreException.toString().indexOf("HADB-S-02097") > 0 ? this.getLocalizedString("TryAfterSomeTime") : sessionStoreException.toString();
                throw new CommandException(string);
            }
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }
}

