/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.IasCommand;
import com.iplanet.ias.tools.cli.PromptStream;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Option;
import java.util.LinkedList;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;

public abstract class BaseOtherCommand
extends IasCommand {
    protected static final String SHORTHAND_DELIMETER = ":";
    protected static final char ESCAPE_CHAR = '\\';
    protected static final String APPEND_WITH_DELIMETER = ".";
    protected static final String QUOTE_CHAR = "\"";
    protected static final String SET_DELIMETER = "=";
    public static final String VIRTUAL_SERVER_CLASS = "defaultclass";

    protected Properties getProperties() throws CommandValidationException {
        Option option = this.findOption("property");
        Properties properties = new Properties();
        if (option == null) {
            return properties;
        }
        String string = option.getValue();
        if (this.isShorthandNotation(string, 0)) {
            this.getPropertiesFromShorthandNotation(properties, string);
        } else {
            int n = this.getSinglePropertyValueIndex(string);
            if (n == -1) {
                throw new CommandValidationException(this.getLocalizedString("NoValueForProperty"));
            }
            String string2 = string.substring(0, n);
            if (string2.indexOf(92) != -1 || string2.indexOf(SET_DELIMETER) != -1) {
                throw new CommandValidationException(this.getLocalizedString("InvalidPropertyName"));
            }
            if (string.length() <= n) {
                throw new CommandValidationException(this.getLocalizedString("InvalidPropertyAttributeSyntax"));
            }
            String string3 = string.substring(n + 1);
            string3 = this.removeEscapeChars(string3);
            properties.put(string2, string3);
        }
        return properties;
    }

    protected int getSinglePropertyValueIndex(String string) {
        int n;
        int n2 = -1;
        boolean bl = false;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) == '\"') {
                if ((n = string.indexOf(34, n + 1)) == -1) {
                    return n;
                }
                if (string.length() != n) continue;
                return -1;
            }
            if (string.charAt(n) != '=' || string.charAt(n - 1) == '\\') continue;
            if (n == 0) {
                return -1;
            }
            return n;
        }
        return n;
    }

    protected void getPropertiesFromShorthandNotation(Properties properties, String string) throws CommandValidationException {
        if (!this.isShorthandNotation(string, 0)) {
            return;
        }
        int n = 0;
        String string2 = string;
        while (string2.length() > 0) {
            String string3;
            n = this.getDelimeterIndex(string2, SHORTHAND_DELIMETER, 0);
            if (n == -1) {
                int n2 = string2.indexOf(SET_DELIMETER);
                if (n2 == -1) {
                    throw new CommandValidationException(this.getLocalizedString("InvalidShorthandNotationForProperty"));
                }
                String string4 = string2.substring(n2 + 1);
                string4 = this.removeEscapeChars(string4);
                string3 = string2.substring(0, n2);
                if (string3.indexOf(92) != -1 || string3.indexOf(SET_DELIMETER) != -1) {
                    throw new CommandValidationException(this.getLocalizedString("InvalidPropertyName"));
                }
                properties.put(string3, string4);
                break;
            }
            String string5 = string2.substring(0, n);
            if (n + 1 >= string2.length()) {
                throw new CommandValidationException(this.getLocalizedString("InvalidShorthandNotationForProperty"));
            }
            string2 = string2.substring(n + 1);
            int n3 = string5.indexOf(SET_DELIMETER);
            if (n3 == -1) {
                throw new CommandValidationException(this.getLocalizedString("InvalidShorthandNotationForProperty"));
            }
            string3 = string5.substring(n3 + 1);
            string3 = this.removeEscapeChars(string3);
            String string6 = string5.substring(0, n3);
            if (string6.indexOf(92) != -1 || string6.indexOf(SET_DELIMETER) != -1) {
                throw new CommandValidationException(this.getLocalizedString("InvalidPropertyName"));
            }
            properties.put(string6, string3);
        }
    }

    protected String removeEscapeChars(String string) throws CommandValidationException {
        int n = 0;
        String string2 = string;
        String string3 = "";
        while (n < string2.length()) {
            int n2 = this.getDelimeterIndex(string2, String.valueOf('\\'), n);
            if (n2 == -1) {
                string3 = string3 + string2.substring(n);
                break;
            }
            string3 = string3 + string2.substring(n, n2);
            n = n2 + 1;
        }
        return string3;
    }

    protected boolean isShorthandNotation(String string, int n) throws CommandValidationException {
        int n2 = this.getDelimeterIndex(string, SHORTHAND_DELIMETER, n);
        return n2 != -1;
    }

    protected int getDelimeterIndex(String string, String string2, int n) throws CommandValidationException {
        int n2 = string.indexOf(string2, n);
        int n3 = string.indexOf(QUOTE_CHAR, n);
        if (n3 != -1 && n2 != -1 && n3 < n2) {
            int n4 = string.indexOf(QUOTE_CHAR, n3 + 1);
            if (n4 == -1) {
                throw new CommandValidationException(this.getLocalizedString("UnclosedString"));
            }
            if (n4 != string.length() - 1) {
                return this.getDelimeterIndex(string, string2, n4 + 1);
            }
            return -1;
        }
        if (n2 > 0 && string.charAt(n2 - 1) == '\\') {
            return this.getDelimeterIndex(string, string2, n2 + 1);
        }
        return n2;
    }

    protected void validateAttributeList(AttributeList attributeList, AttributeList attributeList2) throws CommandException {
        if (attributeList2 != null) {
            for (int i = 0; i < attributeList.size(); ++i) {
                Attribute attribute = (Attribute)attributeList.get(i);
                String string = this.getAttributeValueByName(attributeList2, attribute.getName());
                if (string == null) {
                    throw new CommandException(this.getLocalizedString("CannotSetAttribute"));
                }
                if (string.equals(attribute.getValue().toString())) continue;
                throw new CommandException(this.getLocalizedString("UnableToSetAttribute", new Object[]{attribute.getName(), attribute.getValue().toString()}));
            }
        } else {
            throw new CommandException(this.getLocalizedString("CannotSetAttribute"));
        }
    }

    private String getAttributeValueByName(AttributeList attributeList, String string) {
        for (int i = 0; i < attributeList.size(); ++i) {
            Attribute attribute = (Attribute)attributeList.get(i);
            if (!attribute.getName().equals(string)) continue;
            return attribute.getValue().toString();
        }
        return null;
    }

    protected boolean isProfiler() throws CommandValidationException {
        Option option = this.findOption("profiler");
        if (option == null) {
            return false;
        }
        String string = option.getValue();
        Debug.println("isProfilerStr = " + string);
        boolean bl = false;
        if (string == null) {
            throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue") + ": " + option.getName().toLowerCase());
        }
        if (string.equalsIgnoreCase("true")) {
            bl = true;
        } else if (string.equalsIgnoreCase("false")) {
            bl = false;
        } else {
            throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue") + ": " + option.getName().toLowerCase());
        }
        return bl;
    }

    protected String[] getOptionsList(String string) throws CommandValidationException {
        LinkedList<String> linkedList = new LinkedList<String>();
        int n = 0;
        int n2 = 0;
        while (true) {
            String string2 = null;
            n2 = this.getDelimeterIndex(string, SHORTHAND_DELIMETER, n);
            if (n2 <= 0) break;
            string2 = string.substring(n, n2).replaceAll("\\\\:", SHORTHAND_DELIMETER);
            linkedList.add(string2);
            n = n2 + 1;
        }
        linkedList.add(string.substring(n).replaceAll("\\\\:", SHORTHAND_DELIMETER));
        int n3 = linkedList.size();
        String[] stringArray = new String[n3];
        stringArray = linkedList.toArray(stringArray);
        return stringArray;
    }

    protected boolean confirmBeforeContinue(String string) {
        PromptStream promptStream = new PromptStream(System.in, System.out);
        String string2 = promptStream.readln(string);
        return string2.equals("y") || string2.equals("Y");
    }
}

