/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseOtherCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Operand;
import com.iplanet.ias.tools.cli.framework.Option;

public class AddIIOPClusterEndpointCommand
extends BaseOtherCommand {
    private static final String IIOP_SERVER_INSTANCE = "iiopserverinstance";
    private static final String IIOP_ENDPOINT_ID = "iiopendpointid";
    private static final String IIOP_ENDPOINT_HOST = "iiopendpointhost";
    private static final String IIOP_ENDPOINT_PORT = "iiopendpointport";

    public boolean validateOptions() throws CommandValidationException {
        if (!super.validateOptions()) {
            return false;
        }
        Option option = this.findOption(IIOP_ENDPOINT_PORT);
        if (option != null) {
            int n = 0;
            try {
                n = Integer.parseInt(option.getValue());
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                throw new CommandValidationException(this.getLocalizedString("InvalidPortNumber"));
            }
        }
        return true;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        AppServerInstance appServerInstance = null;
        Object var2_2 = null;
        if (!this.validateOptions()) {
            return;
        }
        try {
            String string = this.findOption(IIOP_SERVER_INSTANCE).getValue();
            String string2 = ((Operand)this.getOperands().get(0)).getName();
            String string3 = this.findOption(IIOP_ENDPOINT_HOST).getValue();
            String string4 = null;
            AddIIOPClusterEndpointCommand.exceptionIfShellChar(string);
            Option option = this.findOption(IIOP_ENDPOINT_PORT);
            if (option != null) {
                string4 = option.getValue();
            }
            ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
            appServerInstance = serverInstanceManager.getServerInstance(this.getInstanceOption());
            appServerInstance.createIIOPEndpoint(string, string2, string3, string4);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotAddIIOPEndpoint"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        this.printMessage(this.getLocalizedString("AddedIIOPEndpoint"));
        Debug.println(this.getClass().getName() + " : Command executed");
    }
}

