/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.util;

import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.ExceptionUtil;
import com.iplanet.ias.admin.util.IOutput;
import com.iplanet.ias.admin.util.NullOutput;
import com.iplanet.ias.admin.util.Output;
import com.iplanet.ias.admin.util.ThrowableToString;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class Debug {
    public static final int LOW = 1;
    public static final int MEDIUM = 2;
    public static final int HIGH = 3;
    public static final int kDefaultSeverity = 1;
    private static int sDebugLevel = 1;
    private static IOutput sOutput = new NullOutput();
    private static boolean sEnabled;

    private static Output createOutput(OutputStream outputStream, boolean bl) throws Exception {
        Output output = new Output(outputStream, bl);
        Debug.cleanup();
        sOutput = output;
        return output;
    }

    private static IOutput createDefaultOutput() {
        IOutput iOutput = null;
        try {
            iOutput = Debug.createOutput(System.err, false);
        }
        catch (Exception exception) {
            ExceptionUtil.ignoreException(exception);
            iOutput = new NullOutput();
        }
        return iOutput;
    }

    private static String getSeverityString(int n) {
        Assert.assertit(Debug.isValidSeverity(n), "illegal severity");
        String string = null;
        switch (n) {
            case 1: {
                string = "LOW";
                break;
            }
            case 2: {
                string = "MEDIUM";
                break;
            }
            case 3: {
                string = "HIGH";
            }
        }
        return string;
    }

    private static String getPrefixString(int n) {
        return "DEBUG: severity " + Debug.getSeverityString(n) + ": ";
    }

    private static boolean testSeverity(int n) {
        return n >= sDebugLevel;
    }

    private static void flush() throws Exception {
        sOutput.flush();
    }

    private static void internalPrintWithException(Object object, int n, boolean bl) throws Exception {
        Assert.assertit(object != null, "null msg");
        if (Debug.testSeverity(n)) {
            String string = bl ? "\n" : "";
            String string2 = Debug.getPrefixString(n) + object.toString();
            if (bl) {
                sOutput.println(string2);
            } else {
                sOutput.print(string2);
            }
        }
    }

    private static void internalPrint(Object object, int n, boolean bl) {
        Assert.assertit(Debug.isValidSeverity(n), "illegal severity");
        if (sEnabled) {
            try {
                Debug.internalPrintWithException(object, n, bl);
            }
            catch (Exception exception) {
                ExceptionUtil.ignoreException(exception);
            }
        }
    }

    public static void setFile(String string) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        sOutput = Debug.createOutput(fileOutputStream, true);
    }

    public static void setDefaultOutput() {
        Debug.createDefaultOutput();
    }

    public static boolean getEnabled() {
        return sEnabled;
    }

    public static void setEnabled(boolean bl) {
        sEnabled = bl;
    }

    private static boolean isValidSeverity(int n) {
        return n == 1 || n == 2 || n == 3;
    }

    public static void setDebugLevel(int n) {
        Assert.assertit(Debug.isValidSeverity(n), "illegal severity");
        sDebugLevel = n;
    }

    public static int getDebugLevel() {
        return sDebugLevel;
    }

    public static void print(Object object, int n) {
        Debug.internalPrint(object, n, false);
    }

    public static void println(Object object, int n) {
        Debug.internalPrint(object, n, true);
    }

    public static void print(Object object) {
        Debug.internalPrint(object, 1, false);
    }

    public static void println(Object object) {
        Debug.internalPrint(object, 1, true);
    }

    public static void printStackTrace(Throwable throwable) {
        Assert.assertit(throwable != null, "null exception");
        Debug.internalPrint(new ThrowableToString(throwable), 3, false);
    }

    public static void cleanup() {
        sOutput.close();
        sOutput = new NullOutput();
    }

    static {
        sOutput = Debug.createDefaultOutput();
        sEnabled = false;
    }
}

