/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.util;

import com.iplanet.ias.admin.util.AssertError;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.SOMLocalStringsManager;
import com.iplanet.ias.admin.util.Validator;
import com.iplanet.ias.admin.util.ValidatorResult;

final class AssertImpl {
    private int mExceptionType = 0;
    private boolean mWantStackTrace = true;
    private String mPreamble = null;
    private static final String sDefaultPreamble = "Assertion Failure: ";
    static final int sAssertError = 0;
    static final int sIllegalArgument = 1;
    private static SOMLocalStringsManager localizedStrMgr = SOMLocalStringsManager.getManager(AssertImpl.class);

    AssertImpl(int n) {
        this("", n);
    }

    AssertImpl(String string, int n) {
        this.mPreamble = string;
        this.mExceptionType = n;
        if (this.mPreamble == null) {
            this.mPreamble = sDefaultPreamble;
        }
        if (this.mPreamble.length() > 0 && !this.mPreamble.endsWith(": ")) {
            this.mPreamble = this.mPreamble + ": ";
        }
        if (this.mExceptionType < 0 || this.mExceptionType > 1) {
            this.lowLevelAssert("Invalid exception type id.  Must be 0 or 1");
            this.mExceptionType = 0;
        }
    }

    void setWantStackTrace(boolean bl) {
        this.mWantStackTrace = bl;
    }

    void assertIt(boolean bl, Object object) {
        if (bl) {
            return;
        }
        String string = null;
        string = object != null ? object.toString() : "boolean test was false";
        this.toss(string);
    }

    void assertRange(long l, long l2, long l3, Object object) {
        if (l < l2 || l > l3) {
            String string = "[" + l2 + ", " + l3 + "]";
            String string2 = "illegal integer value = " + l + " must be in range " + string;
            if (object != null) {
                string2 = string2 + " ( " + object.toString() + " )";
            }
            this.toss(string2);
        }
    }

    void assertValid(Object object, String string, Validator validator) {
        ValidatorResult validatorResult = validator.validate(object);
        if (!validatorResult.isValid()) {
            String string2 = "Validation failed for " + string + ": " + validatorResult.getString();
            this.toss(string2);
        }
    }

    private void toss(String string) throws IllegalArgumentException, AssertError {
        String string2 = this.mPreamble + string;
        Object var3_3 = null;
        if (this.mExceptionType == 1) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
            if (this.mWantStackTrace) {
                Debug.printStackTrace(illegalArgumentException);
            }
            throw illegalArgumentException;
        }
        if (this.mExceptionType == 0) {
            AssertError assertError = new AssertError(string2);
            if (this.mWantStackTrace) {
                Debug.printStackTrace(assertError);
            }
            throw assertError;
        }
        this.lowLevelAssert("Impossible condition -- bad mExceptionType -- " + this.mExceptionType);
    }

    private void pr(String string) {
        Debug.println(string);
    }

    private void lowLevelAssert(String string) {
        String string2 = localizedStrMgr.getString("admin.util.fatal_error_in_setupexceptionconstructor", string);
        throw new AssertError(string2);
    }
}

