/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.beans.AuthRealm;
import com.iplanet.ias.admin.servermodel.beans.SecurityServiceComponentBean;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.StringValidator;
import java.util.Vector;
import javax.management.ObjectName;

public class SecurityServiceComponentController
implements Controller {
    private static final String CREATE_AUTH_REALM = "createAuthRealm";
    private static final String DELETE_AUTH_REALM = "deleteAuthRealm";
    private static final String LIST_AUTH_REALMS = "listAuthRealms";
    private SecurityServiceComponentBean component;

    public SecurityServiceComponentController(SecurityServiceComponentBean securityServiceComponentBean) {
        this.component = securityServiceComponentBean;
    }

    public void createAuthRealm(String string, String string2) throws AFException {
        ArgChecker.checkValid(string, "name", StringValidator.getInstance());
        ArgChecker.checkValid(string2, "className", StringValidator.getInstance());
        this.invoke(CREATE_AUTH_REALM, new Object[]{string, string2}, new String[]{"java.lang.String", "java.lang.String"});
    }

    public void deleteAuthRealm(String string) throws AFException {
        ArgChecker.checkValid(string, "name", StringValidator.getInstance());
        this.invoke(DELETE_AUTH_REALM, new Object[]{string}, new String[]{"java.lang.String"});
    }

    public ServerModelIterator getAuthRealms() throws AFException {
        Vector<AuthRealm> vector = new Vector<AuthRealm>();
        String[] stringArray = (String[])this.invoke(LIST_AUTH_REALMS, null, null);
        if (stringArray != null) {
            String string = this.component.getInstanceName();
            for (int i = 0; i < stringArray.length; ++i) {
                ObjectName objectName = ObjectNames.getAuthRealmObjectName(string, stringArray[i]);
                Assert.assertit(objectName != null, "null value returned");
                AuthRealm authRealm = new AuthRealm(objectName.toString(), stringArray[i]);
                authRealm.setContextHolder(this.component.getContextHolder());
                vector.add(authRealm);
            }
        }
        return new ServerModelIterator(vector);
    }

    private Object invoke(String string, Object[] objectArray, String[] stringArray) throws AFException {
        try {
            ContextHolder contextHolder = this.component.getContextHolder();
            ObjectName objectName = new ObjectName(this.component.getIdentifier());
            SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
            return sOMRequestDispatcher.invoke(objectName, string, objectArray, stringArray);
        }
        catch (Exception exception) {
            if (exception instanceof AFException) {
                throw (AFException)exception;
            }
            throw new AFException(exception.getLocalizedMessage());
        }
    }
}

