/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.beans.Profiler;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.util.ArgChecker;
import javax.management.ObjectName;

public class ProfilerController
implements Controller {
    private static final String GET_JVM_OPTIONS = "getJvmOptions";
    private static final String SET_JVM_OPTIONS = "setJvmOptions";
    private Profiler profiler;

    public ProfilerController(Profiler profiler) {
        this.profiler = profiler;
    }

    public String[] getJvmOptions() throws AFException {
        String[] stringArray = (String[])this.invoke(GET_JVM_OPTIONS, null, null);
        return stringArray;
    }

    public void setJvmOptions(String[] stringArray) throws AFException {
        ArgChecker.checkValid(stringArray, "options");
        String[] stringArray2 = new String[]{stringArray.getClass().getName()};
        Object[] objectArray = new Object[]{stringArray};
        this.invoke(SET_JVM_OPTIONS, objectArray, stringArray2);
    }

    private Object invoke(String string, Object[] objectArray, String[] stringArray) throws AFException {
        try {
            ContextHolder contextHolder = this.profiler.getContextHolder();
            ObjectName objectName = new ObjectName(this.profiler.getIdentifier());
            SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
            return sOMRequestDispatcher.invoke(objectName, string, objectArray, stringArray);
        }
        catch (Exception exception) {
            if (exception instanceof AFException) {
                throw (AFException)exception;
            }
            throw new AFException(exception.getLocalizedMessage());
        }
    }
}

