/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.EntityStatus;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFOtherException;
import com.iplanet.ias.admin.servermodel.beans.DeployedModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.ComponentController;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.ExceptionUtil;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class DeployedModuleComponentController
implements ComponentController {
    private static final String ENABLE_MODULE = "enable";
    private static final String DISABLE_MODULE = "disable";
    private static final String GET_STATUS = "getStatus";
    private DeployedModuleComponentBean deployedModule;

    public DeployedModuleComponentController(DeployedModuleComponentBean deployedModuleComponentBean) {
        this.deployedModule = deployedModuleComponentBean;
    }

    public boolean isEnabled() {
        boolean bl = false;
        try {
            EntityStatus entityStatus = this.getEntityStatus();
            bl = entityStatus.getStatusCode() == 4;
        }
        catch (AFException aFException) {
            Debug.println("Warning : Suppressing the exception");
            Debug.printStackTrace(aFException);
            ExceptionUtil.ignoreException(aFException);
        }
        return bl;
    }

    public boolean enable() {
        boolean bl = false;
        try {
            this.invoke(ENABLE_MODULE, null, null);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
            Debug.println("Warning : Suppressing the exception");
            Debug.printStackTrace(exception);
            ExceptionUtil.ignoreException(exception);
        }
        return bl;
    }

    public boolean disable() {
        boolean bl = false;
        try {
            this.invoke(DISABLE_MODULE, null, null);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
            Debug.println("Warning : Suppressing the exception");
            Debug.printStackTrace(exception);
            ExceptionUtil.ignoreException(exception);
        }
        return bl;
    }

    public String getStatus() {
        String string = null;
        try {
            EntityStatus entityStatus = this.getEntityStatus();
            string = entityStatus.getStatusString();
        }
        catch (AFException aFException) {
            Debug.printStackTrace(aFException);
            Debug.println("Warning : Suppressing exception");
            ExceptionUtil.ignoreException(aFException);
        }
        return string;
    }

    public ServerComponent[] getSubComponents() {
        return null;
    }

    private EntityStatus getEntityStatus() throws AFException {
        EntityStatus entityStatus = (EntityStatus)this.invoke(GET_STATUS, null, null);
        Assert.assertit(entityStatus != null, "null value returned");
        return entityStatus;
    }

    private Object invoke(String string, Object[] objectArray, String[] stringArray) throws AFException {
        ObjectName objectName = null;
        Object object = null;
        try {
            objectName = new ObjectName(this.deployedModule.getIdentifier());
            ContextHolder contextHolder = this.deployedModule.getContextHolder();
            SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
            object = sOMRequestDispatcher.invoke(objectName, string, objectArray, stringArray);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new AFOtherException(malformedObjectNameException);
        }
        return object;
    }
}

