/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.ByteChunk;
import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.ParamInfo;
import com.iplanet.ias.admin.common.domains.registry.DomainEntry;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.common.exception.AttributeNotFoundException;
import com.iplanet.ias.admin.common.exception.ControlException;
import com.iplanet.ias.admin.common.exception.InstanceAlreadyExistsException;
import com.iplanet.ias.admin.common.exception.NoSuchInstanceException;
import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.ExceptionUtil;
import com.iplanet.ias.admin.util.HostAndPort;
import com.iplanet.ias.admin.util.StringValidator;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Vector;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class AdminController
implements Controller {
    public static final String CREATE_INSTANCE = "createServerInstance";
    public static final String DELETE_INSTANCE = "deleteServerInstance";
    public static final String GET_ALL_SERVER_INSTANCES = "listServerInstances";
    public static final String GET_INSTANCE_HOSTPORT = "getHostAndPort";
    public static final String LIST_GENERIC_NAMES = "listGenericDottedNameContinuiations";
    public static final String GET_GENERIC_ATTRIBUTES = "getGenericAttributes";
    public static final String GET_GENERIC_DEFAULT_VALUES = "getGenericAttributeDefaultValues";
    public static final String SET_GENERIC_ATTRIBUTES = "setGenericAttributes";
    public static final String LIST_MONITORABLE_COMPONENTS = "listMonitor";
    public static final String GET_MONITOR_ATTRIBUTES = "getMonitor";
    public static final String SET_MONITOR_ATTRIBUTES = "setMonitor";
    public static final String GET_VERSION = "getVersion";
    public static final String GET_FULL_VERSION = "getFullVersion";
    public static final String STOP_SERVER = "shutdown";
    public static final String LIST_DOMAINS = "listDomains";
    public static final String STOP_DOMAIN = "stopDomain";
    public static final String GET_LICENSE_INFO = "getLicenseInfo";
    private final ServerInstanceManager adminServerComponent;

    public AdminController(ServerInstanceManager serverInstanceManager) {
        this.adminServerComponent = serverInstanceManager;
    }

    public AppServerInstance getServerInstance(String string) throws AFTargetNotFoundException {
        AppServerInstance appServerInstance = null;
        if (string.equals("admin-server")) {
            throw new AFTargetNotFoundException(string);
        }
        try {
            HostAndPort hostAndPort = this.getInstanceHostPort(string);
            Assert.assertit(hostAndPort != null, "null value returned");
            appServerInstance = new AppServerInstance(hostAndPort, string);
            appServerInstance.setContextHolder(this.adminServerComponent.getContextHolder());
        }
        catch (AFException aFException) {
            if (aFException instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)aFException;
            }
            Debug.printStackTrace(aFException);
            ExceptionUtil.ignoreException(aFException);
        }
        return appServerInstance;
    }

    public AppServerInstance getAdminInstance() throws AFException {
        HostAndPort hostAndPort = this.getInstanceHostPort("admin-server");
        Assert.assertit(hostAndPort != null, "null value returned");
        AppServerInstance appServerInstance = new AppServerInstance(hostAndPort, "admin-server");
        appServerInstance.setContextHolder(this.adminServerComponent.getContextHolder());
        return appServerInstance;
    }

    public ServerModelIterator getAllServerInstances() {
        Vector<AppServerInstance> vector = new Vector<AppServerInstance>();
        ObjectName objectName = ObjectNames.getControllerObjectName();
        String[] stringArray = new String[]{};
        Object[] objectArray = new Object[]{};
        ContextHolder contextHolder = this.adminServerComponent.getContextHolder();
        SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
        try {
            String[] stringArray2 = (String[])sOMRequestDispatcher.invoke(objectName, GET_ALL_SERVER_INSTANCES, objectArray, stringArray);
            if (stringArray2 != null) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    AppServerInstance appServerInstance = this.getServerInstance(stringArray2[i]);
                    if (appServerInstance == null) continue;
                    vector.add(appServerInstance);
                }
            }
        }
        catch (AFException aFException) {
            Debug.printStackTrace(aFException);
            ExceptionUtil.ignoreException(aFException);
        }
        return new ServerModelIterator(vector);
    }

    public AppServerInstance createServerInstance(HostAndPort hostAndPort, String string, String string2) throws InstanceAlreadyExistsException, ControlException {
        AppServerInstance appServerInstance = null;
        try {
            ContextHolder contextHolder = this.adminServerComponent.getContextHolder();
            SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
            ObjectName objectName = ObjectNames.getControllerObjectName();
            Debug.println("createServerInstance : controller mbean name = " + objectName.toString());
            Object[] objectArray = new Object[]{string, hostAndPort, string2, Boolean.FALSE};
            String[] stringArray = new String[]{"java.lang.String", "com.iplanet.ias.admin.util.HostAndPort", "java.lang.String", "boolean"};
            Object object = sOMRequestDispatcher.invoke(objectName, CREATE_INSTANCE, objectArray, stringArray);
            Debug.println("createServerInstance : instance " + string + " created successfully");
            appServerInstance = new AppServerInstance(hostAndPort, string);
            appServerInstance.setContextHolder(contextHolder);
        }
        catch (AFException aFException) {
            if (aFException instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)aFException;
            }
            if (aFException instanceof ControlException) {
                throw (ControlException)aFException;
            }
            Debug.printStackTrace(aFException);
            ExceptionUtil.ignoreException(aFException);
        }
        return appServerInstance;
    }

    public AppServerInstance createServerInstance(HostAndPort hostAndPort, String string, String string2, String string3, String string4, int n, String string5, String string6) throws InstanceAlreadyExistsException, ControlException {
        AppServerInstance appServerInstance = null;
        try {
            ContextHolder contextHolder = this.adminServerComponent.getContextHolder();
            SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
            ObjectName objectName = ObjectNames.getControllerObjectName();
            Debug.println("createServerInstance : controller mbean name = " + objectName.toString());
            String[] stringArray = new String[]{"com.iplanet.ias.admin.util.HostAndPort", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "int", "java.lang.String", "java.lang.String", "boolean"};
            Object[] objectArray = new Object[]{hostAndPort, string, string2, string3, string4, new Integer(n), string5, string6, Boolean.FALSE};
            Object object = sOMRequestDispatcher.invoke(objectName, CREATE_INSTANCE, objectArray, stringArray);
            Debug.println("createServerInstance : instance " + string + " created successfully");
            appServerInstance = new AppServerInstance(hostAndPort, string);
            appServerInstance.setContextHolder(contextHolder);
        }
        catch (AFException aFException) {
            if (aFException instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)aFException;
            }
            if (aFException instanceof ControlException) {
                throw (ControlException)aFException;
            }
            Debug.printStackTrace(aFException);
            ExceptionUtil.ignoreException(aFException);
        }
        return appServerInstance;
    }

    public boolean deleteServerInstance(String string) throws NoSuchInstanceException, ControlException {
        boolean bl = false;
        try {
            ContextHolder contextHolder = this.adminServerComponent.getContextHolder();
            SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
            ObjectName objectName = ObjectNames.getControllerObjectName();
            Object[] objectArray = new Object[]{string};
            String[] stringArray = new String[]{"java.lang.String"};
            Object object = sOMRequestDispatcher.invoke(objectName, DELETE_INSTANCE, objectArray, stringArray);
            Debug.println("deleteServerInstance : instance " + string + " deleted successfully");
            bl = true;
        }
        catch (AFException aFException) {
            if (aFException instanceof NoSuchInstanceException) {
                throw (NoSuchInstanceException)aFException;
            }
            if (aFException instanceof ControlException) {
                throw (ControlException)aFException;
            }
            Debug.printStackTrace(aFException);
            ExceptionUtil.ignoreException(aFException);
        }
        return bl;
    }

    public boolean deleteServerInstance(AppServerInstance appServerInstance) throws NoSuchInstanceException, ControlException {
        return this.deleteServerInstance(appServerInstance.getName());
    }

    public AttributeList getGenericAttributes(String[] stringArray) throws AFTargetNotFoundException, AttributeNotFoundException {
        ArgChecker.checkValid(stringArray, "attributes");
        AttributeList attributeList = null;
        try {
            Object[] objectArray = new Object[]{stringArray};
            String[] stringArray2 = new String[]{stringArray.getClass().getName()};
            attributeList = (AttributeList)this.invokeGenericConfigurator(GET_GENERIC_ATTRIBUTES, objectArray, stringArray2);
        }
        catch (AFException aFException) {
            if (aFException instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)aFException;
            }
            if (aFException instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)aFException;
            }
            Debug.printStackTrace(aFException);
            ExceptionUtil.ignoreException(aFException);
        }
        return attributeList;
    }

    public AttributeList getGenericAttributeDefaultValues(String string, String string2, String[] stringArray) throws AFTargetNotFoundException {
        ArgChecker.checkValid(stringArray, "attributes");
        AttributeList attributeList = null;
        try {
            Object[] objectArray = new Object[]{string, string2, stringArray};
            String[] stringArray2 = new String[]{"java.lang.String", "java.lang.String", stringArray.getClass().getName()};
            attributeList = (AttributeList)this.invokeGenericConfigurator(GET_GENERIC_DEFAULT_VALUES, objectArray, stringArray2);
        }
        catch (AFException aFException) {
            if (aFException instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)aFException;
            }
            Debug.printStackTrace(aFException);
            ExceptionUtil.ignoreException(aFException);
        }
        return attributeList;
    }

    public String[] listGenericDottedNameContinuiations(String string) throws AFTargetNotFoundException {
        String[] stringArray = null;
        try {
            Object[] objectArray = new Object[]{string};
            String[] stringArray2 = new String[]{string.getClass().getName()};
            stringArray = (String[])this.invokeGenericConfigurator(LIST_GENERIC_NAMES, objectArray, stringArray2);
        }
        catch (AFException aFException) {
            if (aFException instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)aFException;
            }
            Debug.printStackTrace(aFException);
            ExceptionUtil.ignoreException(aFException);
        }
        return stringArray;
    }

    public AttributeList setGenericAttributes(AttributeList attributeList) throws AFTargetNotFoundException {
        ArgChecker.checkValid(attributeList, "al");
        AttributeList attributeList2 = null;
        try {
            Object[] objectArray = new Object[]{attributeList};
            String[] stringArray = new String[]{"javax.management.AttributeList"};
            attributeList2 = (AttributeList)this.invokeGenericConfigurator(SET_GENERIC_ATTRIBUTES, objectArray, stringArray);
        }
        catch (AFException aFException) {
            if (aFException instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)aFException;
            }
            Debug.printStackTrace(aFException);
            ExceptionUtil.ignoreException(aFException);
        }
        return attributeList2;
    }

    public String[] listMonitorableComponents(String string) throws AFException {
        ArgChecker.checkValid(string, "parent", StringValidator.getInstance());
        Object[] objectArray = new Object[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        String[] stringArray2 = (String[])this.invokeGenericConfigurator(LIST_MONITORABLE_COMPONENTS, objectArray, stringArray);
        return stringArray2;
    }

    public AttributeList getMonitorAttributes(String[] stringArray) throws AFException {
        ArgChecker.checkValid(stringArray, "attributes");
        Object[] objectArray = new Object[]{stringArray};
        String[] stringArray2 = new String[]{stringArray.getClass().getName()};
        AttributeList attributeList = (AttributeList)this.invokeGenericConfigurator(GET_MONITOR_ATTRIBUTES, objectArray, stringArray2);
        return attributeList;
    }

    public AttributeList setMonitorAttributes(AttributeList attributeList) throws AFException {
        ArgChecker.checkValid(attributeList, "al");
        Object[] objectArray = new Object[]{attributeList};
        String[] stringArray = new String[]{"javax.management.AttributeList"};
        AttributeList attributeList2 = (AttributeList)this.invokeGenericConfigurator(SET_MONITOR_ATTRIBUTES, objectArray, stringArray);
        return attributeList2;
    }

    public String getVersion() throws AFException {
        String string = (String)this.invokeServerController(GET_VERSION, null, null);
        Assert.assertit(string != null, "null value returned");
        return string;
    }

    public String getFullVersion() throws AFException {
        String string = (String)this.invokeServerController(GET_FULL_VERSION, null, null);
        Assert.assertit(string != null, "null value returned");
        return string;
    }

    public void stopServer() throws AFException {
        this.invokeServerController(STOP_SERVER, null, null);
    }

    public String uploadFile(String string) throws Exception {
        String string2 = null;
        long l = System.currentTimeMillis();
        ObjectName objectName = new ObjectName("ias:type=controller");
        String string3 = "uploadToServer";
        ContextHolder contextHolder = this.adminServerComponent.getContextHolder();
        SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
        File file = new File(string);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        byte[] byArray = new byte[65536];
        int n = 0;
        long l2 = 0L;
        boolean bl = true;
        boolean bl2 = false;
        long l3 = randomAccessFile.length();
        int n2 = 0;
        while ((n = randomAccessFile.read(byArray)) != -1) {
            Object object;
            l2 += (long)n;
            if (n < byArray.length) {
                object = new byte[n];
                for (int i = 0; i < n; ++i) {
                    object[i] = byArray[i];
                }
                byArray = object;
            }
            if (l2 == l3) {
                bl2 = true;
            }
            object = new ByteChunk(byArray, file.getName(), bl, bl2);
            ParamInfo paramInfo = new ParamInfo(string3, object);
            string2 = (String)sOMRequestDispatcher.invoke(objectName, paramInfo.getOperationName(), paramInfo.getParams(), paramInfo.getSignature());
            Debug.println("Chunk[" + n2 + "] sent");
            ++n2;
            bl = false;
        }
        long l4 = System.currentTimeMillis();
        Debug.println("Time to transfer : " + (l4 - l) + " ms");
        return string2;
    }

    private Object invokeGenericConfigurator(String string, Object[] objectArray, String[] stringArray) throws AFException {
        ContextHolder contextHolder = this.adminServerComponent.getContextHolder();
        SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("ias:type=configurator");
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
        Assert.assertit(objectName != null, "null value returned");
        Object object = sOMRequestDispatcher.invoke(objectName, string, objectArray, stringArray);
        return object;
    }

    private Object invokeServerController(String string, Object[] objectArray, String[] stringArray) throws AFException {
        ContextHolder contextHolder = this.adminServerComponent.getContextHolder();
        SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
        ObjectName objectName = ObjectNames.getControllerObjectName();
        Object object = sOMRequestDispatcher.invoke(objectName, string, objectArray, stringArray);
        return object;
    }

    private HostAndPort getInstanceHostPort(String string) throws AFException {
        ObjectName objectName = ObjectNames.getServerInstanceObjectName(string);
        ContextHolder contextHolder = this.adminServerComponent.getContextHolder();
        SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
        HostAndPort hostAndPort = (HostAndPort)sOMRequestDispatcher.invoke(objectName, GET_INSTANCE_HOSTPORT, null, null);
        return hostAndPort;
    }

    public DomainEntry[] listDomains() throws AFException {
        DomainEntry[] domainEntryArray = (DomainEntry[])this.invokeServerController(LIST_DOMAINS, null, null);
        return domainEntryArray;
    }

    public void stopDomain(boolean bl) throws AFException {
        Object[] objectArray = new Boolean[]{new Boolean(bl)};
        String[] stringArray = new String[]{"boolean"};
        this.invokeServerController(STOP_DOMAIN, objectArray, stringArray);
    }

    public String getLicenseInfo() throws AFException {
        String string = (String)this.invokeServerController(GET_LICENSE_INFO, null, null);
        return string;
    }
}

