/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.beans;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.beans.DeployedComponent;
import com.iplanet.ias.admin.servermodel.beans.DeployedEJBModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedWebModuleComponentBean;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.DeployedApplicationComponentController;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.ExceptionUtil;
import com.iplanet.ias.admin.util.StringValidator;
import java.io.Serializable;
import javax.management.ObjectName;

public class DeployedApplicationComponentBean
extends DeployedComponent
implements Serializable {
    private transient DeployedApplicationComponentController controller = new DeployedApplicationComponentController(this);

    public DeployedApplicationComponentBean(String string, String string2) {
        super(string, string2);
    }

    public Controller getController() {
        return this.controller;
    }

    public ServerModelIterator getEJBModules() throws AFException {
        return this.controller.getEJBModules();
    }

    public DeployedEJBModuleComponentBean getEJBModule(String string) {
        ArgChecker.checkValid(string, "moduleName", StringValidator.getInstance());
        String string2 = this.getInstanceName();
        String string3 = this.getAppName();
        ObjectName objectName = ObjectNames.getEjbModuleObjectName(string2, string, string3);
        Assert.assertit(objectName != null, "null value returned");
        Debug.println("DeployedApplicationComponentBean.getEJBModule: mbeanName = " + objectName);
        DeployedEJBModuleComponentBean deployedEJBModuleComponentBean = new DeployedEJBModuleComponentBean(objectName.toString(), string, false);
        deployedEJBModuleComponentBean.setContextHolder(this.getContextHolder());
        return deployedEJBModuleComponentBean;
    }

    public ServerModelIterator getWebModules() throws AFException {
        return this.controller.getWebModules();
    }

    public DeployedWebModuleComponentBean getWebModule(String string) {
        ArgChecker.checkValid(string, "moduleName", StringValidator.getInstance());
        String string2 = this.getInstanceName();
        String string3 = this.getAppName();
        ObjectName objectName = ObjectNames.getWebModuleObjectName(string2, string, string3);
        Assert.assertit(objectName != null, "null value returned");
        Debug.println("DeployedApplicationComponentBean.getWebModule: mbeanName = " + objectName);
        DeployedWebModuleComponentBean deployedWebModuleComponentBean = new DeployedWebModuleComponentBean(objectName.toString(), string, false);
        deployedWebModuleComponentBean.setContextHolder(this.getContextHolder());
        return deployedWebModuleComponentBean;
    }

    public String[] getAllModules() throws AFException {
        return this.controller.getAllModules();
    }

    public boolean isEnabled() throws AFException {
        return this.controller.isEnabled();
    }

    public boolean enable() throws AFException {
        return this.controller.enable();
    }

    public boolean disable() throws AFException {
        return this.controller.disable();
    }

    public String getStatus() throws AFException {
        return this.controller.getStatus();
    }

    public Serializable getJ2EEDescriptor() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public Serializable getIASDescriptor() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof DeployedApplicationComponentBean) {
            DeployedApplicationComponentBean deployedApplicationComponentBean = (DeployedApplicationComponentBean)object;
            bl = this.identifier.equals(deployedApplicationComponentBean.identifier);
        }
        return bl;
    }

    public String getInstanceName() {
        String string = null;
        try {
            String string2 = this.getIdentifier();
            ObjectName objectName = new ObjectName(string2);
            string = objectName.getKeyProperty("instance-name");
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            ExceptionUtil.ignoreException(exception);
        }
        return string;
    }

    public String getAppName() {
        return this.getDisplayName();
    }
}

