/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel;

import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.HostAndPort;
import java.util.HashMap;
import java.util.Map;

public class ServerInstanceManagerFactory {
    private static ServerInstanceManagerFactory factoryInstance = new ServerInstanceManagerFactory();
    private static ServerInstanceManager localServerInstanceManager;
    private Map simRepository = new HashMap(5);

    private ServerInstanceManagerFactory() {
    }

    public static ServerInstanceManagerFactory getFactory() {
        return factoryInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerInstanceManager getServerInstanceManager() {
        Class clazz = ServerInstanceManagerFactory.class;
        synchronized (clazz) {
            if (localServerInstanceManager == null) {
                localServerInstanceManager = new ServerInstanceManager();
            }
        }
        return localServerInstanceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerInstanceManager getServerInstanceManager(HostAndPort hostAndPort) {
        ServerInstanceManager serverInstanceManager = null;
        ServerInstanceManagerFactory serverInstanceManagerFactory = this;
        synchronized (serverInstanceManagerFactory) {
            serverInstanceManager = (ServerInstanceManager)this.simRepository.get(hostAndPort);
            if (serverInstanceManager == null) {
                serverInstanceManager = new ServerInstanceManager(hostAndPort);
                HostAndPort hostAndPort2 = new HostAndPort(hostAndPort);
                this.simRepository.put(hostAndPort2, serverInstanceManager);
            }
        }
        return serverInstanceManager;
    }

    public ServerInstanceManager getServerInstanceManager(HostAndPort hostAndPort, String string, String string2) {
        ServerInstanceManager serverInstanceManager = this.getServerInstanceManager(hostAndPort);
        Assert.assertit(serverInstanceManager != null, "null value returned");
        serverInstanceManager.setAuthenticationContext(string, string2);
        return serverInstanceManager;
    }
}

