/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.common.domains.registry;

import com.iplanet.ias.admin.common.domains.registry.Locked;
import com.iplanet.ias.admin.common.domains.registry.LockingStore;
import com.iplanet.ias.admin.common.domains.registry.PersistentStore;
import com.iplanet.ias.admin.common.domains.registry.TimeoutException;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

class Unlocked
implements LockingStore {
    private PersistentStore storeImpl;
    private static final int TIMEOUT = 3;
    private static final int ATTEMPTS = 50;

    Unlocked(PersistentStore persistentStore) {
        if (persistentStore == null) {
            throw new NullPointerException("store is null");
        }
        this.storeImpl = persistentStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object readObject() throws IOException, TimeoutException, ClassNotFoundException {
        ObjectInputStream objectInputStream = null;
        Object object = null;
        try {
            objectInputStream = this.getIn();
            object = objectInputStream != null ? objectInputStream.readObject() : null;
        }
        catch (EOFException eOFException) {
            object = null;
        }
        finally {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
        }
        return object;
    }

    public long lastModified() {
        return 0L;
    }

    public void unlock() {
    }

    public void writeObject(Object object) throws IllegalStateException, IOException, TimeoutException {
        throw new IllegalStateException("Unlocked state - writeObject() not allowed");
    }

    public void lock() throws TimeoutException, IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.storeImpl.getLock(), "rws");
        this.getWriteLock(randomAccessFile.getChannel());
        this.storeImpl.setState(new Locked(this.storeImpl, randomAccessFile));
    }

    private ObjectInputStream getIn() throws IOException {
        FileInputStream fileInputStream = new FileInputStream(this.storeImpl.getStore());
        this.getReadLock(fileInputStream.getChannel());
        if (fileInputStream.available() > 0) {
            return new ObjectInputStream(fileInputStream);
        }
        fileInputStream.close();
        return null;
    }

    private FileLock getReadLock(FileChannel fileChannel) throws TimeoutException, IOException {
        return this.obtainLock(fileChannel, true);
    }

    private FileLock getWriteLock(FileChannel fileChannel) throws TimeoutException, IOException {
        return this.obtainLock(fileChannel, false);
    }

    private FileLock obtainLock(FileChannel fileChannel, boolean bl) throws TimeoutException, IOException {
        FileLock fileLock = null;
        int n = 0;
        try {
            while ((fileLock = fileChannel.tryLock(0L, Integer.MAX_VALUE, bl)) == null && n++ < 50) {
                Thread.currentThread();
                Thread.sleep(3L);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new TimeoutException();
        }
        if (fileLock == null) {
            throw new TimeoutException();
        }
        return fileLock;
    }
}

