/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.common.domains.registry;

import com.iplanet.ias.admin.common.domains.registry.LockingStore;
import com.iplanet.ias.admin.common.domains.registry.TimeoutException;
import com.iplanet.ias.admin.common.domains.registry.Unlocked;
import java.io.File;
import java.io.IOException;

class PersistentStore
implements LockingStore {
    private static File STORE;
    private static File LOCK;
    private LockingStore state;
    public static final String CONFIG_ROOT = "com.sun.aas.configRoot";
    public static final String STORE_NAME = "domains.bin";
    public static final String LOCK_NAME = "domains.lck";

    PersistentStore() {
        STORE = new File(System.getProperty(CONFIG_ROOT), STORE_NAME);
        LOCK = new File(System.getProperty(CONFIG_ROOT), LOCK_NAME);
        this.state = new Unlocked(this);
    }

    public long lastModified() {
        return this.getStore().lastModified();
    }

    public Object readObject() throws IOException, TimeoutException, ClassNotFoundException {
        return this.state.readObject();
    }

    public void writeObject(Object object) throws IOException, TimeoutException, IllegalStateException {
        this.state.writeObject(object);
    }

    public void lock() throws IOException, TimeoutException {
        this.state.lock();
    }

    public void unlock() {
        this.state.unlock();
    }

    void setState(LockingStore lockingStore) {
        this.state = lockingStore;
    }

    LockingStore getState() {
        return this.state;
    }

    protected void finalize() {
        this.state.unlock();
    }

    File getLock() {
        return LOCK;
    }

    File getStore() {
        return STORE;
    }
}

