/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.common.domains.registry;

import com.iplanet.ias.admin.common.domains.registry.DomainEntry;
import com.iplanet.ias.admin.common.domains.registry.DomainRegistryException;
import com.iplanet.ias.admin.common.domains.registry.DomainRegistryI;
import com.iplanet.ias.admin.common.domains.registry.LockingStore;
import com.iplanet.ias.admin.common.domains.registry.LockingStoreFactory;
import com.iplanet.ias.admin.common.domains.registry.Registry;
import com.iplanet.ias.admin.common.domains.registry.TimeoutException;
import java.io.IOException;
import java.util.Iterator;

public class DomainRegistry
implements DomainRegistryI {
    private Registry registry;
    private LockingStore store;
    private static DomainRegistry instance = null;
    private long lastModified = 0L;

    public static synchronized DomainRegistry newInstance() throws DomainRegistryException {
        if (instance == null) {
            instance = new DomainRegistry();
            instance.init();
        }
        return instance;
    }

    public synchronized void registerDomain(DomainEntry domainEntry) throws DomainRegistryException {
        this.prepareForUpdate();
        try {
            this.registry.registerDomain(domainEntry);
        }
        catch (DomainRegistryException domainRegistryException) {
            this.store.unlock();
            throw domainRegistryException;
        }
        this.saveRegistry();
    }

    public void unregisterDomain(String string) throws DomainRegistryException {
        this.prepareForUpdate();
        try {
            this.registry.unregisterDomain(string);
        }
        catch (DomainRegistryException domainRegistryException) {
            this.store.unlock();
            throw domainRegistryException;
        }
        this.saveRegistry();
    }

    public void unregisterDomain(DomainEntry domainEntry) throws DomainRegistryException {
        this.unregisterDomain(domainEntry.getName());
    }

    public void reregisterDomain(DomainEntry domainEntry) throws DomainRegistryException {
        this.prepareForUpdate();
        try {
            this.registry.reregisterDomain(domainEntry);
        }
        catch (DomainRegistryException domainRegistryException) {
            this.store.unlock();
            throw domainRegistryException;
        }
        this.saveRegistry();
    }

    public boolean containsDomain(DomainEntry domainEntry) throws DomainRegistryException {
        this.refreshRegistry();
        return this.registry.containsDomain(domainEntry);
    }

    public DomainEntry getDomain(String string) throws DomainRegistryException {
        this.refreshRegistry();
        return this.registry.getDomain(string);
    }

    public Iterator iterator() throws DomainRegistryException {
        this.refreshRegistry();
        return this.registry.iterator();
    }

    public int size() throws DomainRegistryException {
        this.refreshRegistry();
        return this.registry.size();
    }

    void reset() throws IOException {
        this.store.unlock();
        this.registry = null;
        this.store = null;
        instance = null;
    }

    private void refreshRegistry() throws DomainRegistryException {
        if (this.lastModified < this.store.lastModified()) {
            try {
                this.registry = this.getRegistryFromStore();
            }
            catch (Exception exception) {
                throw new DomainRegistryException("problem reading from store", exception);
            }
        }
    }

    private Registry getRegistryFromStore() throws IOException, TimeoutException, ClassNotFoundException {
        Registry registry = (Registry)this.store.readObject();
        return registry != null ? registry : new Registry();
    }

    private void prepareForUpdate() throws DomainRegistryException {
        try {
            this.store.lock();
        }
        catch (Exception exception) {
            throw new DomainRegistryException("problem locking store ", exception);
        }
        this.refreshRegistry();
    }

    private void saveRegistry() throws DomainRegistryException {
        try {
            this.store.writeObject(this.registry);
            this.store.unlock();
            this.lastModified = this.store.lastModified();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new DomainRegistryException("couldn't save registry", exception);
        }
    }

    private void init() throws DomainRegistryException {
        try {
            this.store = LockingStoreFactory.getInstance();
            this.registry = this.getRegistryFromStore();
        }
        catch (Exception exception) {
            throw new DomainRegistryException("couldn't initialize registry. Error message: " + exception.getMessage());
        }
    }

    private DomainRegistry() {
    }
}

