/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.common;

import java.lang.constant.Constable;
import java.util.HashMap;

public class ParamInfo {
    protected String mOperationName = null;
    protected String[] mSignature = null;
    protected Object[] mParams = null;
    protected boolean mForcePrimitives = false;
    private static final HashMap mPrimitives = ParamInfo.createPrimitivesMap();
    private static final HashMap mPrimitiveClasses = ParamInfo.createPrimitiveClassesMap();

    private static HashMap createPrimitivesMap() {
        HashMap<Class, String> hashMap = new HashMap<Class, String>();
        hashMap.put(Integer.class, "int");
        hashMap.put(Boolean.class, "boolean");
        hashMap.put(Float.class, "float");
        hashMap.put(Double.class, "double");
        hashMap.put(Byte.class, "byte");
        hashMap.put(Character.class, "char");
        hashMap.put(Short.class, "short");
        hashMap.put(Long.class, "long");
        return hashMap;
    }

    private static HashMap createPrimitiveClassesMap() {
        HashMap<String, Class<Constable>> hashMap = new HashMap<String, Class<Constable>>();
        hashMap.put("int", Integer.TYPE);
        hashMap.put("boolean", Boolean.TYPE);
        hashMap.put("float", Float.TYPE);
        hashMap.put("double", Double.TYPE);
        hashMap.put("byte", Byte.TYPE);
        hashMap.put("char", Character.TYPE);
        hashMap.put("short", Short.TYPE);
        hashMap.put("long", Long.TYPE);
        return hashMap;
    }

    public static Class getPrimitiveClass(String string) {
        return (Class)mPrimitiveClasses.get(string);
    }

    public void initCoercionOptions() {
        this.mForcePrimitives = false;
    }

    public ParamInfo(String string, Object[] objectArray) {
        this.mOperationName = string;
        this.mParams = objectArray;
        this.initCoercionOptions();
        this.mSignature = this.paramsToClassNames(objectArray);
    }

    public ParamInfo(String string) {
        this(string, new Object[0]);
    }

    public ParamInfo(String string, Object object) {
        this(string, new Object[]{object});
    }

    public ParamInfo(String string, Object object, Object object2) {
        this(string, new Object[]{object, object2});
    }

    public ParamInfo(String string, Object object, Object object2, Object object3) {
        this(string, new Object[]{object, object2, object3});
    }

    public ParamInfo(String string, Object object, Object object2, Object object3, Object object4) {
        this(string, new Object[]{object, object2, object3, object4});
    }

    public String getOperationName() {
        return this.mOperationName;
    }

    public Object[] getParams() {
        return this.mParams;
    }

    public String[] getSignature() {
        return this.mSignature;
    }

    public String[] paramsToClassNames(Object[] objectArray) {
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object var4_4 = null;
            if (this.mForcePrimitives) {
                var4_4 = mPrimitives.get(objectArray[i].getClass());
            }
            stringArray[i] = var4_4 != null ? (String)var4_4 : objectArray[i].getClass().getName();
        }
        return stringArray;
    }
}

