/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.common;

import com.iplanet.ias.admin.common.MalformedNameException;
import com.iplanet.ias.admin.util.SOMLocalStringsManager;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;

public class NameParser {
    private String mString = null;
    private Vector mNameParts = new Vector();
    private static SOMLocalStringsManager localizedStrMgr = SOMLocalStringsManager.getManager(NameParser.class);

    public void parseIt(String string) throws MalformedNameException {
        this.mString = string;
        this.parseStringForNameParts();
        this.parseNameParts();
        if (!this.isWildcardCharValid()) {
            String string2 = localizedStrMgr.getString("admin.common.invalid_wild-card_char_placement");
            throw new MalformedNameException(string2);
        }
    }

    public Iterator getParts() {
        return this.mNameParts.iterator();
    }

    private String removeEscapes(String string) {
        int n;
        while ((n = string.indexOf(92)) >= 0) {
            if (n == 0) {
                string = string.substring(1);
                continue;
            }
            string = string.substring(0, n) + string.substring(n + 1);
        }
        return string;
    }

    private void parseStringForNameParts() throws MalformedNameException {
        int n;
        int n2 = n = 0;
        String string = null;
        while (n < this.mString.length()) {
            char c = this.mString.charAt(n);
            if (this.isValidChar(c)) {
                boolean bl = this.isDelimiterChar(this.mString, n);
                if (bl) {
                    string = this.mString.substring(n2, n);
                    n2 = n + 1;
                    this.mNameParts.addElement(this.removeEscapes(string));
                }
            } else {
                String string2 = localizedStrMgr.getString("admin.common.invalid_char_encountered", new String(c + ""));
                throw new MalformedNameException(string2);
            }
            ++n;
        }
        string = this.mString.substring(n2);
        this.mNameParts.addElement(this.removeEscapes(string));
    }

    private void parseNameParts() throws MalformedNameException {
        Iterator iterator = this.getParts();
        boolean bl = false;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            bl = this.reduceNamePart(string);
            if (bl) continue;
            String string2 = localizedStrMgr.getString("admin.common.invalid_name", this.mString);
            throw new MalformedNameException(string2);
        }
    }

    private boolean isWildcardCharValid() {
        boolean bl = true;
        String string = new String(new char[]{'*'});
        for (int i = 0; i < this.mNameParts.size(); ++i) {
            String string2 = (String)this.mNameParts.elementAt(i);
            if (string2.indexOf(42) == -1 || string2.equals(string)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean isValidChar(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || this.isPermissibleChar(c) || this.isSpecialChar(c);
    }

    private boolean isPermissibleChar(char c) {
        boolean bl = false;
        if (c == '[' || c == ']' || c == '.' || c == '\\' || c == '*') {
            bl = true;
        }
        return bl;
    }

    private boolean isSpecialChar(char c) {
        return "-_/".indexOf(c) != -1;
    }

    private boolean isNonZeroDigit(char c) {
        return "123456789".indexOf(c) != -1;
    }

    private boolean reduceNamePart(String string) {
        boolean bl = true;
        if (this.isSubscriptPresent(string)) {
            bl = this.isSubscriptValid(string);
        }
        if (bl) {
            String string2 = this.removeSubscript(string);
            bl = this.isSubscriptLessStringValid(string2);
        }
        return bl;
    }

    private boolean isDelimiterChar(String string, int n) {
        boolean bl = false;
        if (string.charAt(n) == '.' && (n == 0 || string.charAt(n - 1) != '\\')) {
            bl = true;
        }
        return bl;
    }

    private boolean isValidIndexString(String string) {
        boolean bl = true;
        if (string != null && string.length() > 0) {
            try {
                int n = Integer.parseInt(string);
                if (n == 0 && string.length() != 1 || n > 0 && string.charAt(0) == '0' || n < 0) {
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isSubscriptPresent(String string) {
        boolean bl = false;
        if (string.indexOf(91) != -1 || string.indexOf(93) != -1) {
            bl = true;
        }
        return bl;
    }

    private boolean isSubscriptValid(String string) {
        boolean bl = true;
        boolean bl2 = this.isSubscriptOrdered(string);
        if (bl2) {
            boolean bl3;
            int n;
            int n2 = string.indexOf(91);
            String string2 = string.substring(n2 + 1, n = string.lastIndexOf(93));
            if (!this.isValidIndexString(string2)) {
                bl = false;
            }
            boolean bl4 = bl3 = string.charAt(string.length() - 1) == ']';
            if (!bl3) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isSubscriptOrdered(String string) {
        boolean bl = true;
        Stack<Character> stack = new Stack<Character>();
        if (this.isSubscriptPresent(string)) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '[') {
                    stack.push(new Character(c));
                    continue;
                }
                if (c != ']') continue;
                if (!stack.empty()) {
                    Character c2 = (Character)stack.pop();
                    if (c2.charValue() == '[') continue;
                    bl = false;
                    break;
                }
                bl = false;
                break;
            }
            if (!stack.empty()) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private String removeSubscript(String string) {
        String string2 = null;
        int n = string.indexOf(91);
        if (string != null || string.length() > 0) {
            string2 = n != -1 ? string.substring(0, n) : string;
        }
        return string2;
    }

    private boolean isSubscriptLessStringValid(String string) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            boolean bl2;
            boolean bl3 = this.isOnlyDelimiterEscaped(string);
            boolean bl4 = string.indexOf(92) != -1;
            boolean bl5 = !bl4 || bl4 && bl3;
            boolean bl6 = bl2 = string.indexOf("**") == -1;
            if (bl5 && bl2) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean isOnlyDelimiterEscaped(String string) {
        boolean bl = true;
        if (string != null && string.length() > 0) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                int n2;
                char c = string.charAt(i);
                if (c != '\\' || (n2 = i + 1) < n && string.charAt(n2) == '.') continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }
}

