/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.common;

import com.iplanet.ias.admin.util.GeneralPatternMatcher;
import com.iplanet.ias.admin.util.IPatternMatcher;
import com.iplanet.ias.admin.util.RegExpMatcher;
import com.iplanet.ias.admin.util.SOMLocalStringsManager;

public class CombinedPatternMatcher
implements IPatternMatcher {
    private String mPattern = null;
    private String mTestString = null;
    private IPatternMatcher mRealMatcher = null;
    private static SOMLocalStringsManager localizedStrMgr = SOMLocalStringsManager.getManager(CombinedPatternMatcher.class);

    public CombinedPatternMatcher(String string, String string2) {
        if (string == null || string2 == null) {
            String string3 = localizedStrMgr.getString("admin.common.combinedpattermatcher_null_arg");
            throw new IllegalArgumentException(string3);
        }
        this.mPattern = string;
        this.mTestString = string2;
        if (this.isJDK14()) {
            this.mPattern = this.translateFromJMXToJDK14(string);
            this.mRealMatcher = new RegExpMatcher(this.mPattern, string2);
        } else {
            this.mRealMatcher = new GeneralPatternMatcher(string, string2);
        }
    }

    public boolean matches() {
        return this.mRealMatcher.matches();
    }

    public boolean isJDK14() {
        String string = System.getProperty("java.specification.version");
        return string.startsWith("1.4");
    }

    private String translateFromJMXToJDK14(String string) {
        String string2 = this.escapeDots(string);
        String string3 = this.insertDotBeforeStar(string2);
        String string4 = this.insertDotBeforeQM(string3);
        return string4;
    }

    private String escapeDots(String string) {
        char c = '\\';
        char c2 = '.';
        return this.insertCharBefore(string, c, c2);
    }

    private String insertDotBeforeStar(String string) {
        char c = '.';
        char c2 = '*';
        return this.insertCharBefore(string, c, c2);
    }

    private String insertDotBeforeQM(String string) {
        char c = '.';
        char c2 = '?';
        return this.insertCharBefore(string, c, c2);
    }

    private String insertCharBefore(String string, char c, char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c3 = cArray[i];
            if (c3 == c2) {
                stringBuffer.append(c);
            }
            stringBuffer.append(c3);
        }
        return stringBuffer.toString();
    }
}

