/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.common;

import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class ASException
extends Exception {
    public static final String DEFAULT_BUNDLE = "com.sun.management.services.common.resources.ExceptionResources";
    protected String bundleName = null;
    protected ClassLoader resourceClassLoader = null;
    protected Vector subargs = null;
    protected Exception subexcept = null;

    public ASException(String string) {
        super(string);
    }

    public ASException(String string, String[] stringArray) {
        super(string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addArg(stringArray[i]);
            }
        }
    }

    public ASException(String string, Exception exception) {
        super(string);
        this.subexcept = exception;
    }

    public ASException(String string, String[] stringArray, Exception exception) {
        super(string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addArg(stringArray[i]);
            }
        }
        this.subexcept = exception;
    }

    public void addArg(Object object) {
        this.addNextArg(object);
    }

    public void addArg(String string) {
        this.addNextArg(string);
    }

    public void addArg(Integer n) {
        this.addNextArg(n);
    }

    public void addArg(Long l) {
        this.addNextArg(l);
    }

    public void addArg(Date date) {
        this.addNextArg(date);
    }

    public String getMessage() {
        Locale locale = new Locale("", "");
        return this.getLocalizedMessage(locale);
    }

    public String getLocalizedMessage() {
        Locale locale = Locale.getDefault();
        return this.getLocalizedMessage(locale);
    }

    public String getLocalizedMessage(Locale locale) {
        String string = super.getMessage();
        int n = 0;
        if (this.subargs != null) {
            n = this.subargs.size();
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.subargs.elementAt(i);
        }
        try {
            string = MessageFormat.format(this.getPattern(string, locale), objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public boolean isEmbeddedException() {
        return this.subexcept != null;
    }

    public Exception getEmbeddedException() {
        return this.subexcept;
    }

    public String toString() {
        String string = this.getClass().getName();
        String string2 = this.getLocalizedMessage();
        if (string2 != null) {
            string = string.concat(": ");
            string = string.concat(string2);
        }
        return string;
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.subexcept != null) {
            this.subexcept.printStackTrace();
        }
    }

    public String formatForLogging() {
        String string = "";
        string = this.getBundleName();
        string = string + "&!$";
        string = string + super.getMessage();
        if (this.subargs != null) {
            for (int i = 0; i < this.subargs.size(); ++i) {
                string = string + "&!$";
                Object e = this.subargs.elementAt(i);
                string = string + e.toString();
            }
        }
        return string;
    }

    public static ASException parseLogStr(String string) {
        StringTokenizer stringTokenizer = null;
        if (string != null) {
            stringTokenizer = new StringTokenizer(string, "&!$", false);
        }
        if (stringTokenizer != null) {
            String string2;
            String string3;
            try {
                string3 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
            ASException aSException = new ASException(string2);
            aSException.setBundleName(string3);
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    aSException.addArg(stringTokenizer.nextToken());
                }
                catch (NoSuchElementException noSuchElementException) {
                    return aSException;
                }
            }
            return aSException;
        }
        return null;
    }

    public void setBundleName(String string) {
        this.bundleName = string;
    }

    public void setResourceClassLoader(ClassLoader classLoader) {
        this.resourceClassLoader = classLoader;
    }

    protected String getBundleName() {
        if (this.bundleName == null) {
            return DEFAULT_BUNDLE;
        }
        return this.bundleName;
    }

    protected ClassLoader getResourceClassLoader() {
        return this.resourceClassLoader;
    }

    protected void addNextArg(Object object) {
        if (this.subargs == null) {
            this.subargs = new Vector();
        }
        if (this.subargs.size() < 10) {
            this.subargs.addElement(object);
        }
    }

    protected String getPattern(String string, Locale locale) {
        ResourceBundle resourceBundle = null;
        String string2 = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String string3 = this.getBundleName();
        try {
            resourceBundle = this.getResourceClassLoader() == null ? ResourceBundle.getBundle(string3, locale) : ResourceBundle.getBundle(string3, locale, this.getResourceClassLoader());
            string2 = resourceBundle.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }
}

