/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.common;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public class ASConfiguration {
    private static final String DEFAULT_FILE_PROP = "s1asaudit.default.file";
    private static final String CONFIG_FILE_PROP = "s1asaudit.config.file";
    private static final String SUNOS_NAME = "SunOS";
    private static final String SUNOS_ENV_COMMAND = "env";
    private static final String SUNOS_FILE_DEFAULT_PATH = "/etc/default/s1asaudit";
    private static final String SUNOS_FILE_CONFIG_PATH = "/etc/opt/SUNWappserver7/s1asaudit";
    private static final String LINUX_NAME = "Linux";
    private static final String LINUX_ENV_COMMAND = "env";
    private static final String LINUX_FILE_DEFAULT_PATH = "/etc/default/s1asaudit";
    private static final String LINUX_FILE_CONFIG_PATH = "/etc/opt/SUNWappserver7/s1asaudit";
    private static final String WINDOWS_NT_NAME = "Windows NT";
    private static final String WINDOWS_NT_ENV_COMMAND = "cmd.exe /a /c set";
    private static final String WINDOWS_NT_FILE_DEFAULT_PATH = "C:\\etc\\default\\s1asaudit";
    private static final String WINDOWS_NT_FILE_CONFIG_PATH = "C:\\Sun\\SUNWappserver7\\s1asaudit";
    private static final String WINDOWS_2K_NAME = "Windows 2000";
    private static final String WINDOWS_2K_ENV_COMMAND = "cmd.exe /A /C set";
    private static final String WINDOWS_2K_FILE_DEFAULT_PATH = "C:\\etc\\default\\s1asaudit";
    private static final String WINDOWS_2K_FILE_CONFIG_PATH = "C:\\Sun\\SUNWappserver7\\s1asaudit";
    private static final String OS_NAME_PROP = "os.name";
    private static Properties props = null;
    private static Properties envs = null;

    public static String getProperty(String string) {
        String string2 = null;
        Properties properties = ASConfiguration.loadProperties();
        try {
            string2 = properties.getProperty(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String[] getPropertyList(String string) {
        Properties properties = ASConfiguration.loadProperties();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 1;
        if (string != null) {
            String string2 = string;
            if (!string2.endsWith(".")) {
                string2 = string2.concat(".");
            }
            boolean bl = true;
            while (bl) {
                String string3 = string2 + n;
                try {
                    String string4 = properties.getProperty(string3);
                    if (string4 == null) {
                        bl = false;
                    } else {
                        arrayList.add(string4);
                    }
                }
                catch (Exception exception) {
                    bl = false;
                }
                ++n;
            }
        }
        String[] stringArray = new String[arrayList.size()];
        if (arrayList.size() > 0) {
            arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    public static String[] getPropertyNames() {
        Properties properties = ASConfiguration.loadProperties();
        ArrayList<String> arrayList = new ArrayList<String>(properties.size());
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = new String((String)enumeration.nextElement());
            arrayList.add(string);
        }
        String[] stringArray = new String[arrayList.size()];
        if (arrayList.size() > 0) {
            arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    public static String getEnvProperty(String string) {
        String string2 = null;
        Properties properties = ASConfiguration.loadEnvProperties();
        try {
            string2 = properties.getProperty(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    private static String getOSName() {
        String string = null;
        try {
            string = System.getProperty(OS_NAME_PROP);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private static String getDefaultFileName() {
        String string = null;
        try {
            string = System.getProperty(DEFAULT_FILE_PROP);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            String string2 = ASConfiguration.getOSName();
            if (string2 != null) {
                if (string2.equals(SUNOS_NAME)) {
                    string = "/etc/default/s1asaudit";
                } else if (string2.equals(LINUX_NAME)) {
                    string = "/etc/default/s1asaudit";
                } else if (string2.equals(WINDOWS_NT_NAME)) {
                    string = "C:\\etc\\default\\s1asaudit";
                } else if (string2.equals(WINDOWS_2K_NAME)) {
                    string = "C:\\etc\\default\\s1asaudit";
                }
            }
            if (string == null) {
                string = "/etc/default/s1asaudit";
            }
        }
        return string;
    }

    private static String getConfigFileName() {
        String string = null;
        try {
            string = System.getProperty(CONFIG_FILE_PROP);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            String string2 = ASConfiguration.getOSName();
            if (string2 != null) {
                if (string2.equals(SUNOS_NAME)) {
                    string = "/etc/opt/SUNWappserver7/s1asaudit";
                } else if (string2.equals(LINUX_NAME)) {
                    string = "/etc/opt/SUNWappserver7/s1asaudit";
                } else if (string2.equals(WINDOWS_NT_NAME)) {
                    string = "C:\\Sun\\SUNWappserver7\\s1asaudit";
                } else if (string2.equals(WINDOWS_2K_NAME)) {
                    string = "C:\\Sun\\SUNWappserver7\\s1asaudit";
                }
            }
            if (string == null) {
                string = "/etc/opt/SUNWappserver7/s1asaudit";
            }
        }
        return string;
    }

    private static synchronized Properties loadProperties() {
        Properties properties;
        if (props != null) {
            return props;
        }
        String string = ASConfiguration.getDefaultFileName();
        props = ASConfiguration.loadFileProperties(string);
        string = ASConfiguration.getConfigFileName();
        if (string != null && (properties = ASConfiguration.loadFileProperties(string)) != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)properties.get(string2);
                props.put(string2, string3);
            }
        }
        return props;
    }

    private static synchronized Properties loadFileProperties(String string) {
        boolean bl = false;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = true;
        }
        Properties properties = new Properties();
        if (!bl) {
            try {
                properties.load(bufferedInputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    private static synchronized Properties loadEnvProperties() {
        if (envs != null) {
            return envs;
        }
        String string = null;
        String string2 = ASConfiguration.getOSName();
        if (string2 != null) {
            if (string2.equals(SUNOS_NAME)) {
                string = "env";
            } else if (string2.equals(LINUX_NAME)) {
                string = "env";
            } else if (string2.equals(WINDOWS_NT_NAME)) {
                string = WINDOWS_NT_ENV_COMMAND;
            } else if (string2.equals(WINDOWS_2K_NAME)) {
                string = WINDOWS_2K_ENV_COMMAND;
            }
        }
        if (string == null) {
            string = "env";
        }
        InputStream inputStream = null;
        Properties properties = null;
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(string);
            inputStream = process.getInputStream();
            properties = ASConfiguration.readEnvProps(inputStream, string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (properties == null) {
            properties = new Properties();
        }
        envs = properties;
        return envs;
    }

    private static Properties readEnvProps(InputStream inputStream, String string) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        Properties properties = new Properties();
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf(61);
                if (n <= 0) continue;
                String string3 = new String(string2.substring(0, n));
                String string4 = new String(string2.substring(n + 1));
                if (string.equals(WINDOWS_NT_NAME) || string.equals(WINDOWS_2K_NAME)) {
                    String string5 = string3.toUpperCase();
                    properties.setProperty(string5, string4);
                    continue;
                }
                properties.setProperty(string3, string4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (inputStreamReader != null) {
            try {
                inputStreamReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return properties;
    }

    private static void debugProps(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = new String((String)enumeration.nextElement());
            String string2 = properties.getProperty(string);
        }
    }
}

