/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.comm;

import com.iplanet.ias.admin.comm.HttpConnectorAddress;
import com.iplanet.ias.admin.comm.IConnection;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.SOMLocalStringsManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.net.UnknownHostException;

class ServletConnection
implements IConnection {
    private URLConnection mConnection = null;
    private ObjectOutputStream mObjectOutStream = null;
    private ObjectInputStream mObjectInStream = null;
    private static SOMLocalStringsManager localizedStrMgr = SOMLocalStringsManager.getManager(ServletConnection.class);

    ServletConnection(HttpConnectorAddress httpConnectorAddress) throws IOException {
        try {
            this.mConnection = httpConnectorAddress.openConnection("/web1/entry");
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public Object receive() throws IOException, ClassNotFoundException {
        Object object = null;
        try {
            this.mObjectInStream = new ObjectInputStream(new BufferedInputStream(this.mConnection.getInputStream()));
            object = this.mObjectInStream.readObject();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        return object;
    }

    public void send(Serializable serializable) throws IOException {
        try {
            this.mObjectOutStream = new ObjectOutputStream(new BufferedOutputStream(this.mConnection.getOutputStream()));
            this.mObjectOutStream.writeObject(serializable);
            this.mObjectOutStream.flush();
            this.mObjectOutStream.close();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void close() {
        try {
            this.mObjectInStream.close();
            this.mObjectOutStream.close();
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
    }

    private void handleException(IOException iOException) throws IOException {
        IOException iOException2 = null;
        if (iOException instanceof UnknownHostException) {
            String string = localizedStrMgr.getString("admin.comm.unknown_host");
            iOException2 = new UnknownHostException(string + iOException.getMessage());
        } else if (iOException instanceof ConnectException) {
            String string = localizedStrMgr.getString("admin.comm.invalid_host_port");
            iOException2 = new ConnectException(string);
        } else {
            int n = ((HttpURLConnection)this.mConnection).getResponseCode();
            if (n == 401) {
                String string = localizedStrMgr.getString("admin.comm.unauthorized_access");
                iOException2 = new IOException(string);
            } else {
                iOException2 = iOException;
            }
        }
        throw iOException2;
    }
}

