/*
 * Decompiled with CFR 0.152.
 */
package samples.lifecycle.rmiserver;

import com.sun.appserv.server.LifecycleEvent;
import com.sun.appserv.server.LifecycleEventContext;
import com.sun.appserv.server.LifecycleListener;
import com.sun.appserv.server.ServerLifecycleException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.Naming;
import java.util.Properties;
import samples.lifecycle.rmiserver.SampleRemoteInterface;

public class LifecycleListenerImpl
implements LifecycleListener {
    LifecycleEventContext ctx;
    private Process proc;
    private String policyFile = "nopolicy";
    private SampleRemoteInterface lci;

    public void handleEvent(LifecycleEvent lifecycleEvent) throws ServerLifecycleException {
        this.ctx = lifecycleEvent.getLifecycleEventContext();
        switch (lifecycleEvent.getEventType()) {
            case 0: {
                Properties properties = (Properties)lifecycleEvent.getData();
                try {
                    this.policyFile = properties.getProperty("policy.file");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.onInitTask();
                break;
            }
            case 1: {
                this.onStartTask();
                break;
            }
            case 2: {
                this.onReadyTask();
                break;
            }
            case 3: {
                this.onShutdownTask();
                break;
            }
            case 4: {
                this.onTerminationTask();
            }
        }
    }

    private void onInitTask() {
        this.ctx.log("Lifecycle rmiserver sample: INIT_EVENT");
    }

    private void onStartTask() {
        this.ctx.log("Lifecycle rmiserver sample: STARTUP_EVENT");
        try {
            String string;
            String string2 = string = System.getProperty("JAVA_HOME") + File.separator + "bin" + File.separator;
            string2 = this.isWindows() ? string2 + "java.exe" : string2 + "java";
            String string3 = System.getProperty("java.class.path");
            string2 = string2 + " -Djava.security.policy=" + this.policyFile + " -classpath " + string3 + " samples.lifecycle.rmiserver.SampleRMIServer";
            this.ctx.log("Creating SampleRMIServer");
            this.proc = Runtime.getRuntime().exec(string2);
            InputStream inputStream = this.proc.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string4 = bufferedReader.readLine();
            if (string4 != null) {
                this.ctx.log(string4);
            }
            String string5 = "//localhost/SampleRMIServer";
            this.lci = (SampleRemoteInterface)Naming.lookup(string5);
            this.lci.start();
            string4 = bufferedReader.readLine();
            if (string4 != null) {
                this.ctx.log(string4);
            }
        }
        catch (Exception exception) {
            System.err.println("Client exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private boolean isWindows() {
        String string = System.getProperty("os.name");
        if (string == null || string.length() <= 0) {
            return false;
        }
        return (string = string.toLowerCase()).indexOf("windows") >= 0 && File.separatorChar == '\\';
    }

    private void onReadyTask() {
        this.ctx.log("Lifecycle rmiserver sample: READY_EVENT");
    }

    private void onShutdownTask() {
        this.ctx.log("Lifecycle rmiserver sample: SHUTDOWN_EVENT");
        try {
            String string = "//localhost/SampleRMIServer";
            this.lci.stop();
            InputStream inputStream = this.proc.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string2 = bufferedReader.readLine();
            if (string2 != null) {
                this.ctx.log(string2);
            }
            bufferedReader.close();
            this.ctx.log("Destroying SampleRMIServer");
            this.proc.destroy();
        }
        catch (Exception exception) {
            System.err.println("Client exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void onTerminationTask() {
        this.ctx.log("Lifecycle rmiserver sample: TERMINATION_EVENT");
    }
}

