/*
 * Decompiled with CFR 0.152.
 */
package samples.lifecycle.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class ResourceAccess {
    Connection _connection = null;
    Context _namingCtx = null;
    UserTransaction _userTrans = null;
    private static long serialNumber = 0L;
    private String qrySQL = "SELECT SERIALNUMBER, NAME, MARKS from SAMPLETABLE";
    private String updSQL = "UPDATE SAMPLETABLE SET MARKS=MARKS+1";
    private String insSQL = "INSERT INTO SAMPLETABLE (SERIALNUMBER, NAME, MARKS) VALUES (?, ?, 1.0)";

    public void setInitialContext(Context context) {
        this._namingCtx = context;
    }

    public void initialize() {
        try {
            if (this._namingCtx == null) {
                this._namingCtx = new InitialContext();
            }
            this._userTrans = (UserTransaction)this._namingCtx.lookup("java:comp/UserTransaction");
        }
        catch (NamingException namingException) {
            System.out.println("[samples.lifecycle.jdbc.ResourceAccess.getNamingContext()]:: " + namingException);
            namingException.printStackTrace();
        }
    }

    public void openConnection() {
        try {
            DataSource dataSource = (DataSource)this._namingCtx.lookup("jdbc/lifecycle-jdbc");
            this._connection = dataSource.getConnection();
        }
        catch (Exception exception) {
            System.out.println("[samples.lifecycle.jdbc.ResourceAccess.openConnection()]:: " + exception);
            exception.printStackTrace();
        }
    }

    public void closeConnection() {
        try {
            if (this._connection != null) {
                this._connection.close();
            }
        }
        catch (Exception exception) {
            System.out.println("[samples.lifecycle.jdbc.ResourceAccess.closeConnection()]:: " + exception);
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void insert() {
        block21: {
            if (this._connection == null) {
                System.out.println("[samples.lifecycle.jdbc.ResourceAccess.insert()]:: Connection lost OR not initialized");
                return;
            }
            PreparedStatement preparedStatement = null;
            preparedStatement = this._connection.prepareStatement(this.insSQL);
            ResourceAccess resourceAccess = this;
            synchronized (resourceAccess) {
                preparedStatement.setLong(1, serialNumber++);
            }
            preparedStatement.setString(2, "abc" + serialNumber);
            this._userTrans.begin();
            preparedStatement.executeUpdate();
            this._userTrans.commit();
            Object var5_7 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                break block21;
            }
            catch (SQLException sQLException) {
                System.out.println("[samples.lifecycle.jdbc.ResourceAccess.insert()]:: " + sQLException);
                sQLException.printStackTrace();
            }
            break block21;
            {
                catch (SQLException sQLException) {
                    try {
                        if (this._userTrans != null) {
                            this._userTrans.rollback();
                        }
                    }
                    catch (SystemException systemException) {
                        System.out.println("[samples.lifecycle.jdbc.ResourceAccess.insert()]:: " + (Object)((Object)systemException));
                        systemException.printStackTrace();
                    }
                    System.out.println("[samples.lifecycle.jdbc.ResourceAccess.insert()]:: " + sQLException);
                    sQLException.printStackTrace();
                    Object var5_8 = null;
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        break block21;
                    }
                    catch (SQLException sQLException2) {
                        System.out.println("[samples.lifecycle.jdbc.ResourceAccess.insert()]:: " + sQLException2);
                        sQLException2.printStackTrace();
                    }
                    break block21;
                }
                catch (Exception exception) {
                    System.out.println("[samples.lifecycle.jdbc.ResourceAccess.insert()]:: " + exception);
                    exception.printStackTrace();
                    Object var5_9 = null;
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        break block21;
                    }
                    catch (SQLException sQLException) {
                        System.out.println("[samples.lifecycle.jdbc.ResourceAccess.insert()]:: " + sQLException);
                        sQLException.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("[samples.lifecycle.jdbc.ResourceAccess.insert()]:: " + sQLException);
                    sQLException.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void update() {
        block18: {
            if (this._connection == null) {
                System.out.println("[samples.lifecycle.jdbc.ResourceAccess.update()]:: Connection lost OR not initialized");
                return;
            }
            Statement statement = null;
            statement = this._connection.createStatement();
            this._userTrans.begin();
            statement.executeUpdate(this.updSQL);
            this._userTrans.commit();
            Object var5_2 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                break block18;
            }
            catch (SQLException sQLException) {
                System.out.println("[samples.lifecycle.jdbc.ResourceAccess.insert()]:: " + sQLException);
                sQLException.printStackTrace();
            }
            break block18;
            {
                catch (SQLException sQLException) {
                    try {
                        if (this._userTrans != null) {
                            this._userTrans.rollback();
                        }
                    }
                    catch (SystemException systemException) {
                        System.out.println("[samples.lifecycle.jdbc.ResourceAccess.insert()]:: " + (Object)((Object)systemException));
                        systemException.printStackTrace();
                    }
                    System.out.println("[samples.lifecycle.jdbc.ResourceAccess.update()]:: " + sQLException);
                    sQLException.printStackTrace();
                    Object var5_3 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        break block18;
                    }
                    catch (SQLException sQLException2) {
                        System.out.println("[samples.lifecycle.jdbc.ResourceAccess.insert()]:: " + sQLException2);
                        sQLException2.printStackTrace();
                    }
                    break block18;
                }
                catch (Exception exception) {
                    System.out.println("[samples.lifecycle.jdbc.ResourceAccess.update()]:: " + exception);
                    exception.printStackTrace();
                    Object var5_4 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        break block18;
                    }
                    catch (SQLException sQLException) {
                        System.out.println("[samples.lifecycle.jdbc.ResourceAccess.insert()]:: " + sQLException);
                        sQLException.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("[samples.lifecycle.jdbc.ResourceAccess.insert()]:: " + sQLException);
                    sQLException.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ArrayList query() {
        ArrayList arrayList;
        block20: {
            if (this._connection == null) {
                System.out.println("[samples.lifecycle.jdbc.ResourceAccess.query()]:: Connection lost OR not initialized");
                return null;
            }
            Statement statement = null;
            arrayList = null;
            ResultSet resultSet = null;
            statement = this._connection.createStatement();
            resultSet = statement.executeQuery(this.qrySQL);
            arrayList = new ArrayList();
            while (resultSet.next()) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add(Long.toString(resultSet.getLong(1)));
                arrayList2.add(resultSet.getString(2));
                arrayList2.add(Double.toString(resultSet.getDouble(3)));
                arrayList.add(arrayList2);
            }
            Object var6_7 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                break block20;
            }
            catch (SQLException sQLException) {
                System.out.println("[samples.lifecycle.jdbc.ResourceAccess.query()]:: " + sQLException);
                sQLException.printStackTrace();
            }
            break block20;
            {
                catch (SQLException sQLException) {
                    System.out.println("[samples.lifecycle.jdbc.ResourceAccess.query()]:: " + sQLException);
                    sQLException.printStackTrace();
                    Object var6_8 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        break block20;
                    }
                    catch (SQLException sQLException2) {
                        System.out.println("[samples.lifecycle.jdbc.ResourceAccess.query()]:: " + sQLException2);
                        sQLException2.printStackTrace();
                    }
                    break block20;
                }
                catch (Exception exception) {
                    System.out.println("[samples.lifecycle.jdbc.ResourceAccess.query()]:: " + exception);
                    exception.printStackTrace();
                    Object var6_9 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        break block20;
                    }
                    catch (SQLException sQLException) {
                        System.out.println("[samples.lifecycle.jdbc.ResourceAccess.query()]:: " + sQLException);
                        sQLException.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println("[samples.lifecycle.jdbc.ResourceAccess.query()]:: " + sQLException);
                    sQLException.printStackTrace();
                }
                throw throwable;
            }
        }
        return arrayList;
    }

    public void doWork() {
        this.initialize();
        this.openConnection();
        this.print(this.query());
        this.insert();
        this.print(this.query());
        this.update();
        this.print(this.query());
        this.closeConnection();
    }

    private void print(ArrayList arrayList) {
        if (arrayList == null) {
            return;
        }
        System.out.println("The Existing records in the SAMPLETABLE are:");
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            System.out.println("serial no. =" + (String)((ArrayList)arrayList.get(i)).get(0));
            System.out.println("name       =" + (String)((ArrayList)arrayList.get(i)).get(1));
            System.out.println("marks      =" + (String)((ArrayList)arrayList.get(i)).get(2));
            System.out.println("");
        }
    }
}

