/*
 * Decompiled with CFR 0.152.
 */
package samples.webservices.jaxr.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.Slot;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;

public class JAXRQueryPostal {
    Connection connection = null;

    public static void main(String[] stringArray) {
        String string = "http://www-3.ibm.com/services/uddi/v2beta/inquiryapi";
        String string2 = "https://www-3.ibm.com/services/uddi/v2beta/protect/publishapi";
        if (stringArray.length < 2) {
            System.out.println("Usage: ant run-query -Dquery-string=<value> -Duuid-string=<value>");
            System.exit(1);
        }
        String string3 = new String(stringArray[0]);
        System.out.println("Query string is " + string3);
        String string4 = new String(stringArray[1]);
        System.out.println("UUID string is " + string4);
        JAXRQueryPostal jAXRQueryPostal = new JAXRQueryPostal();
        jAXRQueryPostal.makeConnection(string, string2, string4);
        jAXRQueryPostal.executeQuery(string3);
    }

    public void makeConnection(String string, String string2, String string3) {
        block4: {
            String string4 = "";
            String string5 = "8080";
            Properties properties = new Properties();
            properties.setProperty("javax.xml.registry.queryManagerURL", string);
            properties.setProperty("com.sun.xml.registry.http.proxyHost", string4);
            properties.setProperty("com.sun.xml.registry.http.proxyPort", string5);
            properties.setProperty("javax.xml.registry.postalAddressScheme", string3);
            properties.setProperty("javax.xml.registry.semanticEquivalences", "urn:uuid:PostalAddressAttributes/StreetNumber,urn:" + string3 + "/MyStreetNumber|" + "urn:uuid:PostalAddressAttributes/Street," + "urn:" + string3 + "/MyStreet|" + "urn:uuid:PostalAddressAttributes/City," + "urn:" + string3 + "/MyCity|" + "urn:uuid:PostalAddressAttributes/State," + "urn:" + string3 + "/MyState|" + "urn:uuid:PostalAddressAttributes/PostalCode," + "urn:" + string3 + "/MyPostalCode|" + "urn:uuid:PostalAddressAttributes/Country," + "urn:" + string3 + "/MyCountry");
            try {
                ConnectionFactory connectionFactory = ConnectionFactory.newInstance();
                connectionFactory.setProperties(properties);
                this.connection = connectionFactory.createConnection();
                System.out.println("Created connection to registry");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (this.connection == null) break block4;
                try {
                    this.connection.close();
                }
                catch (JAXRException jAXRException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeQuery(String string) {
        RegistryService registryService = null;
        BusinessQueryManager businessQueryManager = null;
        registryService = this.connection.getRegistryService();
        businessQueryManager = registryService.getBusinessQueryManager();
        System.out.println("Got registry service and query manager");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("sortByNameDesc");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("%" + string + "%");
        BulkResponse bulkResponse = businessQueryManager.findOrganizations(arrayList, arrayList2, null, null, null, null);
        Collection collection = bulkResponse.getCollection();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Collection collection2;
            Iterator iterator2;
            Collection collection3;
            Object object;
            Object object2;
            Object object3;
            Organization organization = (Organization)iterator.next();
            System.out.println("Org name: " + this.getName((RegistryObject)organization));
            System.out.println("Org description: " + this.getDescription((RegistryObject)organization));
            System.out.println("Org key id: " + this.getKey((RegistryObject)organization));
            User user = organization.getPrimaryContact();
            if (user != null) {
                Collection collection4;
                object3 = user.getPersonName();
                System.out.println(" Contact name: " + object3.getFullName());
                object2 = user.getTelephoneNumbers(null);
                object = object2.iterator();
                while (object.hasNext()) {
                    collection3 = (TelephoneNumber)object.next();
                    System.out.println("  Phone number: " + collection3.getNumber());
                }
                collection3 = user.getEmailAddresses();
                iterator2 = collection3.iterator();
                while (iterator2.hasNext()) {
                    collection2 = (EmailAddress)iterator2.next();
                    System.out.println("  Email Address: " + collection2.getAddress());
                }
                collection2 = user.getPostalAddresses();
                Iterator iterator3 = collection2.iterator();
                while (iterator3.hasNext()) {
                    collection4 = (PostalAddress)iterator3.next();
                    System.out.println("  Postal Address (PostalAddress methods):\n    " + collection4.getStreetNumber() + " " + collection4.getStreet() + "\n    " + collection4.getCity() + ", " + collection4.getStateOrProvince() + " " + collection4.getPostalCode() + "\n    " + collection4.getCountry());
                }
                collection4 = user.getPostalAddresses();
                Iterator iterator4 = collection4.iterator();
                while (iterator4.hasNext()) {
                    PostalAddress postalAddress = (PostalAddress)iterator4.next();
                    Collection collection5 = postalAddress.getSlots();
                    Iterator iterator5 = collection5.iterator();
                    System.out.println("  Postal Address (Slot methods):");
                    while (iterator5.hasNext()) {
                        Slot slot = (Slot)iterator5.next();
                        Collection collection6 = slot.getValues();
                        Iterator iterator6 = collection6.iterator();
                        while (iterator6.hasNext()) {
                            String string2 = (String)iterator6.next();
                            System.out.println("    Line: " + string2);
                        }
                    }
                }
            }
            object3 = organization.getServices();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (Service)object2.next();
                System.out.println(" Service name: " + this.getName((RegistryObject)object));
                System.out.println(" Service description: " + this.getDescription((RegistryObject)object));
                collection3 = object.getServiceBindings();
                iterator2 = collection3.iterator();
                while (iterator2.hasNext()) {
                    collection2 = (ServiceBinding)iterator2.next();
                    System.out.println("  Binding Description: " + this.getDescription((RegistryObject)collection2));
                    System.out.println("  Access URI: " + collection2.getAccessURI());
                }
            }
            System.out.println(" --- ");
        }
        Object var28_28 = null;
        if (this.connection == null) return;
        try {
            this.connection.close();
            return;
        }
        catch (JAXRException jAXRException) {}
        return;
        {
            catch (Exception exception) {
                exception.printStackTrace();
                Object var28_29 = null;
                if (this.connection == null) return;
                try {
                    this.connection.close();
                    return;
                }
                catch (JAXRException jAXRException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var28_30 = null;
            if (this.connection == null) throw throwable;
            try {
                this.connection.close();
                throw throwable;
            }
            catch (JAXRException jAXRException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private String getName(RegistryObject registryObject) throws JAXRException {
        try {
            return registryObject.getName().getValue();
        }
        catch (NullPointerException nullPointerException) {
            return "No Name";
        }
    }

    private String getDescription(RegistryObject registryObject) throws JAXRException {
        try {
            return registryObject.getDescription().getValue();
        }
        catch (NullPointerException nullPointerException) {
            return "No Description";
        }
    }

    private String getKey(RegistryObject registryObject) throws JAXRException {
        try {
            return registryObject.getKey().getId();
        }
        catch (NullPointerException nullPointerException) {
            return "No Key";
        }
    }
}

