/*
 * Decompiled with CFR 0.152.
 */
package samples.webservices.jaxr.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;

public class JAXRQueryByWSDLClassification {
    Connection connection = null;

    public static void main(String[] stringArray) {
        String string = "http://www-3.ibm.com/services/uddi/v2beta/inquiryapi";
        String string2 = "https://www-3.ibm.com/services/uddi/v2beta/protect/publishapi";
        JAXRQueryByWSDLClassification jAXRQueryByWSDLClassification = new JAXRQueryByWSDLClassification();
        jAXRQueryByWSDLClassification.makeConnection(string, string2);
        jAXRQueryByWSDLClassification.executeQuery();
    }

    public void makeConnection(String string, String string2) {
        block4: {
            String string3 = "";
            String string4 = "8080";
            String string5 = "";
            String string6 = "8080";
            Properties properties = new Properties();
            properties.setProperty("javax.xml.registry.queryManagerURL", string);
            properties.setProperty("javax.xml.registry.lifeCycleManagerURL", string2);
            properties.setProperty("com.sun.xml.registry.http.proxyHost", string3);
            properties.setProperty("com.sun.xml.registry.http.proxyPort", string4);
            properties.setProperty("com.sun.xml.registry.https.proxyHost", string5);
            properties.setProperty("com.sun.xml.registry.https.proxyPort", string6);
            try {
                ConnectionFactory connectionFactory = ConnectionFactory.newInstance();
                connectionFactory.setProperties(properties);
                this.connection = connectionFactory.createConnection();
                System.out.println("Created connection to registry");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (this.connection == null) break block4;
                try {
                    this.connection.close();
                }
                catch (JAXRException jAXRException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeQuery() {
        RegistryService registryService = this.connection.getRegistryService();
        BusinessQueryManager businessQueryManager = registryService.getBusinessQueryManager();
        BusinessLifeCycleManager businessLifeCycleManager = registryService.getBusinessLifeCycleManager();
        System.out.println("Got registry service, query manager, and lifecycle manager");
        String string = "uddi-org:types";
        ClassificationScheme classificationScheme = businessQueryManager.findClassificationSchemeByName(null, string);
        Classification classification = businessLifeCycleManager.createClassification(classificationScheme, "wsdlSpec", "wsdlSpec");
        ArrayList<Classification> arrayList = new ArrayList<Classification>();
        arrayList.add(classification);
        BulkResponse bulkResponse = businessQueryManager.findConcepts(null, null, arrayList, null, null);
        Collection collection = bulkResponse.getCollection();
        Iterator iterator = collection.iterator();
        if (!iterator.hasNext()) {
            System.out.println("No WSDL specification concepts found");
        } else {
            while (iterator.hasNext()) {
                ExternalLink externalLink;
                Concept concept = (Concept)iterator.next();
                String string2 = this.getName((RegistryObject)concept);
                Collection collection2 = concept.getExternalLinks();
                System.out.println("\nSpecification Concept:\n\tName: " + string2 + "\n\tKey: " + concept.getKey().getId() + "\n\tDescription: " + this.getDescription((RegistryObject)concept));
                if (collection2.size() > 0) {
                    externalLink = (ExternalLink)collection2.iterator().next();
                    System.out.println("\tURL of WSDL document: '" + externalLink.getExternalURI() + "'");
                }
                externalLink = new ArrayList();
                externalLink.add(concept);
                bulkResponse = businessQueryManager.findOrganizations(null, null, null, (Collection)externalLink, null, null);
                Collection collection3 = bulkResponse.getCollection();
                Iterator iterator2 = collection3.iterator();
                if (iterator2.hasNext()) {
                    System.out.println("Organizations using the '" + string2 + "' WSDL Specification:");
                } else {
                    System.out.println("No Organizations using the '" + string2 + "' WSDL Specification");
                }
                while (iterator2.hasNext()) {
                    Organization organization = (Organization)iterator2.next();
                    System.out.println("\tName: " + this.getName((RegistryObject)organization) + "\n\tKey: " + organization.getKey().getId() + "\n\tDescription: " + this.getDescription((RegistryObject)organization));
                }
            }
        }
        Object var19_19 = null;
        if (this.connection == null) return;
        try {
            this.connection.close();
            return;
        }
        catch (JAXRException jAXRException) {}
        return;
        {
            catch (Exception exception) {
                exception.printStackTrace();
                Object var19_20 = null;
                if (this.connection == null) return;
                try {
                    this.connection.close();
                    return;
                }
                catch (JAXRException jAXRException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var19_21 = null;
            if (this.connection == null) throw throwable;
            try {
                this.connection.close();
                throw throwable;
            }
            catch (JAXRException jAXRException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private String getName(RegistryObject registryObject) throws JAXRException {
        try {
            return registryObject.getName().getValue();
        }
        catch (NullPointerException nullPointerException) {
            return "No Name";
        }
    }

    private String getDescription(RegistryObject registryObject) throws JAXRException {
        try {
            return registryObject.getDescription().getValue();
        }
        catch (NullPointerException nullPointerException) {
            return "No Description";
        }
    }

    private String getKey(RegistryObject registryObject) throws JAXRException {
        try {
            return registryObject.getKey().getId();
        }
        catch (NullPointerException nullPointerException) {
            return "No Key";
        }
    }
}

