/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.gui.servlet;

import com.iplanet.ias.admin.server.core.AdminService;
import com.iplanet.ias.admin.server.gui.jato.I18NResourceBundleModel;
import com.iplanet.ias.admin.server.gui.servlet.MultipartHandler;
import com.iplanet.ias.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UploadServlet
extends HttpServlet {
    private static final String CFG_MAX_UPLOAD_SIZE = "maxUploadSize";
    private static final int MAX_UPLOAD_SIZE = 0xA00000;
    int maxUploadSize = 0xA00000;
    String tempDir = null;
    ServletContext ctxt = null;
    String mesg = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.ctxt = this.getServletContext();
        this.tempDir = AdminService.getAdminService().getGUITempDirPath();
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = null;
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        PrintWriter printWriter = httpServletResponse.getWriter();
        String string2 = httpServletRequest.getContentType();
        String string3 = "";
        Object var7_7 = null;
        if (string2.toLowerCase().startsWith("multipart/form-data")) {
            if (this.tempDir == null) {
                System.out.println("tempDir is null");
            }
            MultipartHandler multipartHandler = null;
            try {
                multipartHandler = new MultipartHandler(httpServletRequest, this.tempDir, this.maxUploadSize);
                multipartHandler.parseMultipartUpload();
            }
            catch (Exception exception) {
                System.out.println("UploadServlet exception thrown in multReq..." + exception.getMessage());
                return;
            }
            Enumeration enumeration = multipartHandler.getFileNames();
            if (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                File file = multipartHandler.getFile(string4);
                if (file != null && this.checkFile(file)) {
                    string = file.getAbsolutePath();
                } else {
                    this.sendResponse(httpServletRequest, httpServletResponse);
                }
            }
        }
        if (FileUtils.isJar(string)) {
            httpServletRequest.setAttribute("filePath", string);
            string3 = "../module1/DeployEJBModule";
        } else if (FileUtils.isWar(string)) {
            httpServletRequest.setAttribute("filePath", string);
            string3 = "../module1/DeployWebApplication";
        } else if (FileUtils.isRar(string)) {
            httpServletRequest.setAttribute("filePath", string);
            string3 = "../module1/DeployConnector";
        } else if (FileUtils.isEar(string)) {
            httpServletRequest.setAttribute("filePath", string);
            string3 = "../module1/DeployEARApplication";
        } else {
            this.sendResponse(httpServletRequest, httpServletResponse);
            return;
        }
        try {
            httpServletRequest.getRequestDispatcher(string3).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (Exception exception) {
            System.out.println("UpLoad:Exception in getting request Dispatcher..." + exception.getMessage());
            this.ctxt.log("UploadServlet: Exception in getting RequestDispatcher");
            this.ctxt.log(exception.getMessage() + " " + exception.getClass());
        }
    }

    private boolean checkFile(File file) {
        boolean bl = true;
        file.deleteOnExit();
        if (file.length() <= 0L) {
            bl = false;
        }
        return bl;
    }

    private void sendResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = this.getLocalizedString("MSG_FileNotFound");
        httpServletRequest.setAttribute("Script", (Object)"Upload");
        httpServletRequest.setAttribute("Response", (Object)string);
        try {
            httpServletRequest.getRequestDispatcher("../ResponseServlet").forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (Exception exception) {
            System.out.println("Exception in getting ResponseServlet");
            exception.printStackTrace();
            this.ctxt.log("UploadServlet: Exception in getting RequestDispatcher");
            this.ctxt.log(exception.getClass() + " " + exception.getMessage());
        }
    }

    private String getLocalizedString(String string) {
        return I18NResourceBundleModel.getLocalizedString(string);
    }
}

