/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.gui.jato;

import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.server.gui.util.ResponseBean;
import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.ServerInstanceManagerFactory;
import com.iplanet.ias.admin.servermodel.beans.DeployedComponent;
import com.iplanet.ias.admin.servermodel.beans.DeployedWebModuleComponentBean;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestHandler;
import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.RequestHandlingTiledViewBase;
import com.iplanet.jato.view.TiledView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.html.StaticTextField;
import javax.servlet.http.HttpServletRequest;

public class WebModulesListTiledView
extends RequestHandlingTiledViewBase
implements TiledView,
RequestHandler {
    private static final String CHILD_SERVLET = "servlet";
    private static final String CHILD_JSP = "jsp";
    private String appName;
    private ServerInstanceManagerFactory simFactory = null;
    private ServerInstanceManager sim = null;
    private String instanceName = null;
    private AppServerInstance si = null;
    private RequestContext rc = null;

    public WebModulesListTiledView(View view, String string, RequestContext requestContext) {
        super(view, string);
        this.setPrimaryModel((DatasetModel)this.getDefaultModel());
        this.setMaxDisplayTiles(-1);
        this.simFactory = ServerInstanceManagerFactory.getFactory();
        this.sim = this.simFactory.getServerInstanceManager();
        this.rc = requestContext;
        HttpServletRequest httpServletRequest = requestContext.getRequest();
        this.instanceName = (String)httpServletRequest.getSession().getAttribute("instance-name");
        try {
            this.si = this.sim.getServerInstance(this.instanceName);
        }
        catch (AFTargetNotFoundException aFTargetNotFoundException) {
            String string2 = aFTargetNotFoundException.getMessage() + " " + ((Object)((Object)aFTargetNotFoundException)).getClass();
            requestContext.getServletContext().log("ModuleList Exception");
            ResponseBean.sendResponse(string2, "DeployConfig", requestContext);
        }
        this.registerChild(CHILD_SERVLET, StaticTextField.class);
        this.registerChild(CHILD_JSP, StaticTextField.class);
    }

    protected View createChild(String string) {
        if (string.equals(CHILD_SERVLET)) {
            return new StaticTextField((View)this, (Model)this.getPrimaryModel(), CHILD_SERVLET, CHILD_SERVLET, (Object)"", null);
        }
        if (string.equals(CHILD_JSP)) {
            return new StaticTextField((View)this, (Model)this.getPrimaryModel(), CHILD_JSP, CHILD_JSP, (Object)"", null);
        }
        throw new IllegalArgumentException("Invalid child name [" + string);
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public void beginDisplay(DisplayEvent displayEvent) throws ModelControlException {
        if (this.getPrimaryModel() == null) {
            throw new ModelControlException("Primary model is null");
        }
        super.beginDisplay(displayEvent);
        this.loadWebapps();
        this.resetTileIndex();
    }

    private void loadWebapps() {
        try {
            DeployedWebModuleComponentBean deployedWebModuleComponentBean = this.si.getDeployedWebModule(this.appName);
            this.loadServlets(deployedWebModuleComponentBean);
        }
        catch (Exception exception) {
            String string = exception.getMessage() + " " + exception.getClass();
            ResponseBean.sendResponse(string, "DeployWebApplications", this.rc);
        }
    }

    private void loadServlets(DeployedWebModuleComponentBean deployedWebModuleComponentBean) throws Exception {
        ServerModelIterator serverModelIterator = deployedWebModuleComponentBean.getServlets();
        this.displayWebapps(serverModelIterator, CHILD_SERVLET);
    }

    private void displayWebapps(ServerModelIterator serverModelIterator, String string) throws Exception {
        DefaultModel defaultModel = (DefaultModel)this.getPrimaryModel();
        if (serverModelIterator != null) {
            defaultModel.beforeFirst();
            while (serverModelIterator.hasNext()) {
                if (!defaultModel.next()) {
                    defaultModel.appendRow();
                }
                DeployedComponent deployedComponent = (DeployedComponent)serverModelIterator.next();
                defaultModel.setValue(string, (Object)deployedComponent.toString());
            }
        }
    }

    private void loadJsps(DeployedWebModuleComponentBean deployedWebModuleComponentBean) throws Exception {
        ServerModelIterator serverModelIterator = deployedWebModuleComponentBean.getJSPs();
        this.displayWebapps(serverModelIterator, CHILD_JSP);
    }
}

