/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.gui.jato;

import com.iplanet.ias.admin.common.constant.ConfigAttributeName;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.server.gui.jato.CheckBoxTiledView;
import com.iplanet.ias.admin.server.gui.jato.I18NResourceBundleModel;
import com.iplanet.ias.admin.server.gui.jato.IASViewBean;
import com.iplanet.ias.admin.server.gui.util.ResponseBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedApplicationComponentBean;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.beans.VirtualServer;
import com.iplanet.ias.admin.servermodel.beans.VirtualServerClass;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.ComboBox;
import com.iplanet.jato.view.html.OptionList;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;

public class VirtualServerViewBean
extends IASViewBean
implements ConfigAttributeName.VirtualServer,
ConfigAttributeName.HTTPQos {
    public static final String PAGE_NAME = "VirtualServer";
    public static final String DEFAULT_VS_CLASS_ID = "defaultclass";
    public static final String CHILD_SETTINGS = "Settings";
    private static final String CHILD_TILEDACLS = "Acls";
    private static final String CHILD_TILEDHTTPLISTENER = "HttpListener";
    private String vsID;
    private String virtualServerName;
    private static String[] name = new String[]{"Id", "Hosts", "Mime", "WebModule", "State", "AccptLang", "LogFile", "BandwidthLimit", "BandwidthEnforce", "ConnectionLimit", "ConnectionEnforce", "Dir", "Nice", "User", "Group", "ChRoot", "DocRoot", "AccessLog"};
    private static String[] configName = new String[]{"id", "hosts", "mime", "defaultWebModule", "state", "accepotLanguage", "logFile", "bandwidthLimit", "enforceBandwidthLimit", "connectionLimit", "enforceConnectionLimit", "property.dir", "property.nice", "property.user", "property.group", "property.chroot", "property.docroot", "property.accesslog"};
    private static short[] type = new short[]{1, 1, 5, 5, 5, 3, 1, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1};
    private static String[] listName = new String[]{"Id", "State", "Hosts"};

    public VirtualServerViewBean(RequestContext requestContext) {
        super(requestContext, PAGE_NAME);
        this.virtualServerName = (String)requestContext.getRequest().getSession().getAttribute("virtualserver");
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(CHILD_TILEDHTTPLISTENER, CheckBoxTiledView.class);
        this.registerChild(CHILD_TILEDACLS, CheckBoxTiledView.class);
    }

    protected View createChild(String string) {
        if (string.equals(CHILD_TILEDHTTPLISTENER)) {
            ServerModelIterator serverModelIterator = null;
            try {
                serverModelIterator = this.getInstance().getHttpService().getHttpListeners();
            }
            catch (AFException aFException) {
                // empty catch block
            }
            return new CheckBoxTiledView((View)this, string, serverModelIterator);
        }
        if (string.equals(CHILD_TILEDACLS)) {
            ServerModelIterator serverModelIterator = null;
            try {
                serverModelIterator = this.getInstance().getHttpService().getAcls();
            }
            catch (AFException aFException) {
                // empty catch block
            }
            return new CheckBoxTiledView((View)this, string, serverModelIterator);
        }
        return super.createChild(string);
    }

    public void beginDisplay(DisplayEvent displayEvent) throws ModelControlException {
        InstanceEnvironment instanceEnvironment;
        super.beginDisplay(displayEvent);
        if (this.getMode() == 1) {
            try {
                instanceEnvironment = new InstanceEnvironment(this.getInstanceName());
                this.setDisplayFieldValue("DocRoot", instanceEnvironment.getDocRootPath());
                this.setDisplayFieldValue("AccessLog", instanceEnvironment.getDefaultAccessLogPath());
                this.setDisplayFieldValue("Mime", "mime1");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.virtualServerName != null) {
            try {
                instanceEnvironment = this.getServerComponent(this.virtualServerName);
                Object object = instanceEnvironment.getAttribute("httpListeners");
                ((CheckBoxTiledView)this.getChild(CHILD_TILEDHTTPLISTENER)).setStringValue(object.toString());
                object = instanceEnvironment.getAttribute("acls");
                ((CheckBoxTiledView)this.getChild(CHILD_TILEDACLS)).setStringValue(object.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.populateState();
        this.populateMime();
        this.populateDefaultWebModule();
    }

    public void edit(Object object) {
        this.vsID = object.toString();
        super.edit(object);
    }

    protected String[] getConfigNames() {
        return configName;
    }

    protected String[] getDisplayNames() {
        return name;
    }

    protected short[] getTypes() {
        return type;
    }

    protected String[] getListNames() {
        return listName;
    }

    protected void add() throws Exception {
        VirtualServerClass virtualServerClass = this.getInstance().getHttpService().getVirtualServerClass(DEFAULT_VS_CLASS_ID);
        String string = this.getDisplayFieldStringValue(name[0]);
        String string2 = this.getDisplayFieldStringValue(name[0]);
        if (string2.length() == 0) {
            string2 = null;
        }
        virtualServerClass.createVirtualServer(string, this.getDisplayFieldStringValue(name[1]), this.getDisplayFieldStringValue(name[2]));
        VirtualServer virtualServer = virtualServerClass.getVirtualServer(string);
        for (int i = 3; i < name.length; ++i) {
            virtualServer.setAttribute(configName[i], this.getDisplayFieldValue(name[i]));
        }
        virtualServer.setAttribute("defaultObject", (Object)"default");
        virtualServer.setAttribute("httpListeners", (Object)((CheckBoxTiledView)this.getChild(CHILD_TILEDHTTPLISTENER)).getStringValue());
        virtualServer.setAttribute("acls", (Object)((CheckBoxTiledView)this.getChild(CHILD_TILEDACLS)).getStringValue());
    }

    protected ServerComponent getServerComponent(String string) throws Exception {
        VirtualServerClass virtualServerClass = this.getInstance().getHttpService().getVirtualServerClass(DEFAULT_VS_CLASS_ID);
        this.vsID = string;
        VirtualServer virtualServer = virtualServerClass.getVirtualServer(string);
        if (!virtualServer.isHttpQosCreated()) {
            virtualServer.createHttpQos();
        }
        return virtualServer;
    }

    public String getAddURL() {
        this.virtualServerName = null;
        return "CreateVirtualServer.jsp";
    }

    public String getEditURL() {
        return "IWSVS.jsp?virtualserver=" + this.vsID;
    }

    public String getEditSingleURL() {
        return "EditVirtualServer.jsp";
    }

    public String getPageName() {
        return PAGE_NAME;
    }

    public String getForwardPageName() {
        return "VirtualServers";
    }

    public String getKeyAttribute() {
        return name[0];
    }

    protected String getListViewBeanName() {
        return "VirtualServersViewBean";
    }

    protected IASViewBean getIASViewBean() {
        return this;
    }

    protected void postSave(RequestInvocationEvent requestInvocationEvent) {
        super.edit(this.vsID);
        this.setDefaultDisplayURL("EditVirtualServer.jsp");
        this.forwardTo(requestInvocationEvent.getRequestContext());
    }

    protected void postRevert(RequestInvocationEvent requestInvocationEvent) {
        this.postSave(requestInvocationEvent);
    }

    private void populateState() {
        String string = "State";
        ComboBox comboBox = this.getComboBoxChild(string);
        String[] stringArray = new String[]{"on", "off", "disabled"};
        String[] stringArray2 = new String[]{VirtualServerViewBean.getLocalizedString("OPTION_On"), VirtualServerViewBean.getLocalizedString("OPTION_Off"), VirtualServerViewBean.getLocalizedString("OPTION_Disabled")};
        OptionList optionList = new OptionList(stringArray2, stringArray);
        comboBox.setOptions(optionList);
    }

    private void populateMime() {
        String string;
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            stringArray = this.getInstance().getHttpService().getMimes();
            while (stringArray.hasNext()) {
                string = ((ServerComponent)stringArray.next()).getDisplayName();
                arrayList.add(string);
            }
        }
        catch (AFException aFException) {
            this.setErrorMessage(aFException.getMessage());
        }
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        string = new OptionList(stringArray, stringArray);
        ComboBox comboBox = this.getComboBoxChild("Mime");
        comboBox.setLabelForNoneSelected(I18NResourceBundleModel.getLocalizedString("MSG_None_Selected"));
        comboBox.setOptions((OptionList)string);
    }

    private void populateDefaultWebModule() {
        String string;
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            stringArray = this.getInstance().getDeployedWebModules();
            while (stringArray.hasNext()) {
                string = ((ServerComponent)stringArray.next()).getDisplayName();
                arrayList.add(string);
            }
            this.populateEARWebModules(arrayList);
        }
        catch (AFException aFException) {
            this.setErrorMessage(aFException.getMessage());
        }
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        string = new OptionList(stringArray, stringArray);
        ComboBox comboBox = this.getComboBoxChild("WebModule");
        comboBox.setLabelForNoneSelected(I18NResourceBundleModel.getLocalizedString("MSG_None_Selected"));
        comboBox.setOptions((OptionList)string);
    }

    private void populateEARWebModules(ArrayList arrayList) throws AFException {
        ServerModelIterator serverModelIterator = this.getInstance().getDeployedApplications();
        while (serverModelIterator.hasNext()) {
            String string = ((ServerComponent)serverModelIterator.next()).getDisplayName();
            DeployedApplicationComponentBean deployedApplicationComponentBean = this.getInstance().getDeployedApplication(string);
            ServerModelIterator serverModelIterator2 = deployedApplicationComponentBean.getWebModules();
            while (serverModelIterator2.hasNext()) {
                arrayList.add(string + ":" + ((ServerComponent)serverModelIterator2.next()).getDisplayName());
            }
        }
    }

    public void handleSaveRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        try {
            ServerComponent serverComponent = this.getServerComponent((String)this.getDisplayFieldValue(this.getKeyAttribute() + HIDDEN));
            serverComponent.setAttribute("httpListeners", (Object)((CheckBoxTiledView)this.getChild(CHILD_TILEDHTTPLISTENER)).getStringValue());
            serverComponent.setAttribute("acls", (Object)((CheckBoxTiledView)this.getChild(CHILD_TILEDACLS)).getStringValue());
        }
        catch (Exception exception) {
            ResponseBean.sendResponse(exception.getMessage(), this.getPageName(), this.getRequestContext());
        }
        super.handleSaveRequest(requestInvocationEvent);
    }

    protected String getObjectType() {
        return "virtual-server-class";
    }

    protected void handleError(RequestInvocationEvent requestInvocationEvent, String string) {
        if (this.getMode() == 2) {
            this.setDefaultDisplayURL(this.getEditSingleURL());
        }
        super.handleError(requestInvocationEvent, string);
    }
}

