/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.gui.jato;

import com.iplanet.ias.admin.common.constant.ConfigAttributeName;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFRuntimeStoreException;
import com.iplanet.ias.admin.server.gui.jato.BasicViewBeanBase;
import com.iplanet.ias.admin.server.gui.jato.I18NResourceBundleModel;
import com.iplanet.ias.admin.server.gui.jato.IASViewBean;
import com.iplanet.ias.admin.server.gui.jato.IndexTreeModel;
import com.iplanet.ias.admin.server.gui.jato.IndexTreeModelImpl;
import com.iplanet.ias.admin.server.gui.jato.IndexTreeNode;
import com.iplanet.ias.admin.server.gui.jato.InstanceNode;
import com.iplanet.ias.admin.server.gui.jato.InstanceRootNode;
import com.iplanet.ias.admin.server.gui.jato.ServerInstancesViewBean;
import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.RequestHandlingTiledViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBeanBase;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.event.TiledViewRequestInvocationEvent;
import com.iplanet.jato.view.html.CheckBox;
import com.iplanet.jato.view.html.HREF;
import com.iplanet.jato.view.html.StaticTextField;
import com.iplanet.jato.view.html.TextField;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ServerInstancesTiledViewBean
extends RequestHandlingTiledViewBase
implements ConfigAttributeName.Server {
    public static final String CHILD_CHECKBOX = "select";
    public static final String CHILD_INSTANCENAME = "instancename";
    public static final String CHILD_APPROOT = "approot";
    public static final String CHILD_STATUS = "status";
    public static final String CHILD_CONFIGCHANGES = "configchanges";
    public static final String CHILD_MESSAGE = "message";
    public static final String CHILD_HREFLINK = "HrefLink";

    public ServerInstancesTiledViewBean(View view, String string) {
        super(view, string);
        this.setMaxDisplayTiles(-1);
        this.setPrimaryModel((DatasetModel)this.getDefaultModel());
        this.registerChildren();
    }

    protected void registerChildren() {
        this.registerChild(CHILD_INSTANCENAME, StaticTextField.class);
        this.registerChild(CHILD_APPROOT, StaticTextField.class);
        this.registerChild(CHILD_STATUS, StaticTextField.class);
        this.registerChild(CHILD_CONFIGCHANGES, StaticTextField.class);
        this.registerChild(CHILD_HREFLINK, HREF.class);
    }

    protected View createChild(String string) {
        if (string.equals(CHILD_CHECKBOX)) {
            return new CheckBox((View)this, this.getDefaultModel(), CHILD_CHECKBOX, (Object)"T", (Object)"F", false);
        }
        if (string.equals(CHILD_INSTANCENAME) || string.equals(CHILD_APPROOT) || string.equals(CHILD_STATUS) || string.equals(CHILD_CONFIGCHANGES)) {
            return new TextField((View)this, (Model)this.getPrimaryModel(), string, string, (Object)"", null);
        }
        if (string.equals(CHILD_HREFLINK)) {
            return new HREF((View)this, (Model)this.getPrimaryModel(), CHILD_HREFLINK, CHILD_HREFLINK, (Object)"", null);
        }
        return null;
    }

    public void beginDisplay(DisplayEvent displayEvent) throws ModelControlException {
        if (this.getPrimaryModel() == null) {
            throw new ModelControlException("Primary model is null");
        }
        super.beginDisplay(displayEvent);
        this.loadModel();
        this.resetTileIndex();
    }

    private void loadModel() {
        AppServerInstance appServerInstance = null;
        try {
            IndexTreeModel indexTreeModel = IndexTreeModelImpl.getIndexTreeModel(this.getRequestContext());
            InstanceRootNode instanceRootNode = indexTreeModel.getInstanceRoot();
            List list = instanceRootNode.getChildren();
            ((ServerInstancesViewBean)this.getParent()).setTable(list.size() == 0);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                InstanceNode instanceNode = (InstanceNode)iterator.next();
                ((DefaultModel)this.getPrimaryModel()).appendRow();
                this.getPrimaryModel().setValue(CHILD_INSTANCENAME, (Object)instanceNode.getName());
                this.getPrimaryModel().setValue(CHILD_HREFLINK, (Object)instanceNode.getPath());
                appServerInstance = instanceNode.getInstance();
                if (appServerInstance == null) continue;
                try {
                    this.getPrimaryModel().setValue(CHILD_APPROOT, (Object)((String)appServerInstance.getAttribute("applicationRoot")));
                    this.getPrimaryModel().setValue(CHILD_STATUS, (Object)appServerInstance.getStatus());
                    if (instanceNode.isApplyNeeded() || instanceNode.isRestartNeeded()) {
                        this.getPrimaryModel().setValue(CHILD_CONFIGCHANGES, (Object)I18NResourceBundleModel.getLocalizedString("VALUE_Yes"));
                        continue;
                    }
                    this.getPrimaryModel().setValue(CHILD_CONFIGCHANGES, (Object)I18NResourceBundleModel.getLocalizedString("VALUE_No"));
                }
                catch (AFException aFException) {
                }
                catch (AFRuntimeStoreException aFRuntimeStoreException) {
                    if (appServerInstance == null) continue;
                    this.getPrimaryModel().setValue(CHILD_CONFIGCHANGES, (Object)I18NResourceBundleModel.getLocalizedString("MSG_ManualChanges"));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void handleHrefLinkRequest(RequestInvocationEvent requestInvocationEvent) throws Exception {
        int n = ((TiledViewRequestInvocationEvent)requestInvocationEvent).getTileNumber();
        this.getPrimaryModel().setLocation(n);
        String string = (String)this.getPrimaryModel().getValue(CHILD_HREFLINK);
        IndexTreeNode indexTreeNode = IndexTreeModelImpl.getIndexTreeModel(this.getRequestContext()).getNode(string);
        this.getRequestContext().getRequest().getSession().setAttribute("selectedNode", (Object)indexTreeNode);
        this.getRequestContext().getRequest().getSession().setAttribute("instance-name", (Object)indexTreeNode.getInstanceName());
        if (indexTreeNode.getViewBeanClass() != null) {
            Class<?> clazz = Class.forName(indexTreeNode.getViewBeanClass());
            ViewBeanBase viewBeanBase = (ViewBeanBase)this.getViewBean(clazz);
            if (viewBeanBase instanceof IASViewBean && indexTreeNode.isEditNode()) {
                IASViewBean iASViewBean = (IASViewBean)viewBeanBase;
                iASViewBean.setAttributes(indexTreeNode.getAttributes());
                iASViewBean.edit(indexTreeNode.getName());
            }
            viewBeanBase.forwardTo(requestInvocationEvent.getRequestContext());
        } else if (indexTreeNode.getHtmlName() != null) {
            RequestContext requestContext = requestInvocationEvent.getRequestContext();
            requestContext.getServletContext().getRequestDispatcher(BasicViewBeanBase.getLocalizedURL(requestContext, indexTreeNode.getHtmlName())).forward((ServletRequest)requestContext.getRequest(), (ServletResponse)requestContext.getResponse());
        } else {
            ((ViewBeanBase)this.getParent()).forwardTo(requestInvocationEvent.getRequestContext());
        }
    }
}

