/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.gui.jato;

import com.iplanet.ias.admin.common.constant.ConfigAttributeName;
import com.iplanet.ias.admin.common.exception.AFRuntimeStoreException;
import com.iplanet.ias.admin.server.gui.jato.IASPropertySheetViewBean;
import com.iplanet.ias.admin.servermodel.beans.AuthRealm;
import com.iplanet.ias.admin.servermodel.beans.SecurityServiceComponentBean;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.html.ComboBox;
import com.iplanet.jato.view.html.OptionList;
import java.util.ArrayList;

public class SecurityServiceViewBean
extends IASPropertySheetViewBean
implements ConfigAttributeName.SecurityService {
    private static String[] name = new String[]{"DefaultRealm", "AnonymousRole", "AuditEnabled", "LogLevel"};
    private static String[] configName = new String[]{"defaultRealm", "anonymousRole", "auditEnabled", "logLevel"};
    private static short[] type = new short[]{5, 1, 3, 4};
    public static final String PAGE_NAME = "SecurityService";
    RequestContext rc = null;

    public SecurityServiceViewBean(RequestContext requestContext) {
        super(requestContext, PAGE_NAME);
        this.rc = requestContext;
    }

    public String getDefaultURL() {
        return "SecurityService.jsp";
    }

    public ServerComponent getServerComponent() {
        return this.getInstance().getSecurityService();
    }

    protected String[] getConfigNames() {
        return configName;
    }

    protected String getPageName() {
        return PAGE_NAME;
    }

    protected String[] getDisplayNames() {
        return name;
    }

    protected short[] getTypes() {
        return type;
    }

    public void beginDisplay(DisplayEvent displayEvent) throws ModelControlException {
        super.beginDisplay(displayEvent);
        try {
            this.populateRealm();
        }
        catch (AFRuntimeStoreException aFRuntimeStoreException) {
            throw aFRuntimeStoreException;
        }
        catch (Exception exception) {
            this.setErrorMessage(exception.getMessage());
        }
    }

    private void populateRealm() throws Exception {
        ComboBox comboBox = this.getComboBoxChild("DefaultRealm");
        ArrayList arrayList = this.getRealmList();
        SecurityServiceComponentBean securityServiceComponentBean = this.getInstance().getSecurityService();
        if (arrayList != null) {
            String[] stringArray = arrayList.toArray(new String[0]);
            OptionList optionList = new OptionList(stringArray, stringArray);
            comboBox.setOptions(optionList);
            String string = (String)securityServiceComponentBean.getAttribute("defaultRealm");
            comboBox.setValue((Object)string);
        }
    }

    private ArrayList getRealmList() throws Exception {
        ServerModelIterator serverModelIterator = null;
        SecurityServiceComponentBean securityServiceComponentBean = this.getInstance().getSecurityService();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (securityServiceComponentBean != null && (serverModelIterator = securityServiceComponentBean.getAuthRealms()) != null) {
            while (serverModelIterator.hasNext()) {
                AuthRealm authRealm = (AuthRealm)serverModelIterator.next();
                arrayList.add(authRealm.getDisplayName());
            }
        }
        return arrayList;
    }
}

