/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.gui.jato;

import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.server.gui.jato.BasicViewBeanBase;
import com.iplanet.ias.admin.server.gui.jato.I18NResourceBundleModel;
import com.iplanet.ias.admin.server.gui.jato.IndexTreeNode;
import com.iplanet.ias.admin.server.gui.jato.InstanceNotFoundException;
import com.iplanet.ias.admin.server.gui.util.ResponseBean;
import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.util.Logger;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBeanBase;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.HREF;
import com.iplanet.jato.view.html.StaticTextField;
import com.iplanet.jato.view.html.TextField;
import java.io.IOException;
import javax.servlet.ServletException;

public class ReconfigViewBean
extends ViewBeanBase {
    public static final String PAGE_NAME = "Reconfig";
    public static final String DEFAULT_DISPLAY_URL = BasicViewBeanBase.DEFAULT_DISPLAY_URL_DIR + "Reconfig.jsp";
    public static final String CHILD_LOAD = "Load";
    public static final String CHILD_DUMP = "Dump";
    private AppServerInstance instance;
    private String instanceName;
    public static final String CHILD_INSTANCENAME = "InstanceName";

    public ReconfigViewBean(RequestContext requestContext) throws InstanceNotFoundException, AFException {
        super(PAGE_NAME);
        IndexTreeNode indexTreeNode = (IndexTreeNode)requestContext.getRequest().getSession().getAttribute("selectedNode");
        if (indexTreeNode != null) {
            this.instanceName = indexTreeNode.getInstanceName();
            if (this.instanceName != null) {
                try {
                    this.instance = indexTreeNode.getInstance();
                }
                catch (AFTargetNotFoundException aFTargetNotFoundException) {
                    throw new InstanceNotFoundException(this.instanceName);
                }
            }
        } else {
            Logger.log((String)"Selected Node is null in the session");
        }
        this.registerChild(CHILD_INSTANCENAME, StaticTextField.class);
        this.setDefaultDisplayURL(BasicViewBeanBase.getLocalizedURL(requestContext, DEFAULT_DISPLAY_URL));
        this.registerChildren();
    }

    protected void registerChildren() {
        this.registerChild(CHILD_LOAD, HREF.class);
        this.registerChild(CHILD_DUMP, HREF.class);
        this.registerChild(CHILD_INSTANCENAME, StaticTextField.class);
    }

    protected View createChild(String string) {
        if (string.equals(CHILD_LOAD) || string.equals(CHILD_DUMP)) {
            return new HREF((ContainerView)this, string, (Object)"");
        }
        if (string.equals(CHILD_INSTANCENAME)) {
            return new TextField((ContainerView)this, CHILD_INSTANCENAME, (Object)this.instanceName);
        }
        return super.createChild(string);
    }

    public void handleLoadRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        try {
            boolean bl = this.instance.useManualChanges();
            if (bl) {
                ResponseBean.sendResponse(I18NResourceBundleModel.getLocalizedString("MSG_RestartRequired"), "TopFrameset", this.getRequestContext());
            } else {
                String string = BasicViewBeanBase.getLocalizedHTML(requestInvocationEvent.getRequestContext(), "/index.html");
                requestInvocationEvent.getRequestContext().getResponse().sendRedirect(".." + string);
            }
        }
        catch (Exception exception) {
            ResponseBean.sendResponse(exception.getMessage(), "TopFrameset", this.getRequestContext());
        }
    }

    public void handleDumpRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        try {
            boolean bl = this.instance.overwriteChanges();
            if (bl) {
                ResponseBean.sendResponse(I18NResourceBundleModel.getLocalizedString("MSG_RestartRequired"), "TopFrameset", this.getRequestContext());
            } else {
                String string = BasicViewBeanBase.getLocalizedHTML(requestInvocationEvent.getRequestContext(), "/index.html");
                requestInvocationEvent.getRequestContext().getResponse().sendRedirect(".." + string);
            }
        }
        catch (Exception exception) {
            ResponseBean.sendResponse(exception.getMessage(), "TopFrameset", this.getRequestContext());
        }
    }
}

