/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.gui.jato;

import com.iplanet.ias.admin.common.constant.ConfigAttributeName;
import com.iplanet.ias.admin.server.gui.jato.IASPropertySheetViewBean;
import com.iplanet.ias.admin.server.gui.jato.ProfilerTiledView;
import com.iplanet.ias.admin.servermodel.beans.JVMComponentBean;
import com.iplanet.ias.admin.servermodel.beans.Profiler;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.Button;
import com.iplanet.jato.view.html.TextField;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;

public class ProfilerViewBean
extends IASPropertySheetViewBean
implements ConfigAttributeName.Profiler {
    public static final String CHILD_PROFILER_TILEDVIEW = "ProfilerView";
    public static final String CHILD_JVMOPTION = "JvmOption";
    public static final String CHILD_DELETE = "Delete";
    private static String[] name = new String[]{"Name", "ClassPath", "NativeLibraryPath", "Enabled"};
    private static String[] configName = new String[]{"name", "classpath", "nativeLibraryPath", "enabled"};
    private static short[] type = new short[]{1, 1, 1, 3};
    public static final String PAGE_NAME = "Profiler";

    public ProfilerViewBean(RequestContext requestContext) {
        super(requestContext, PAGE_NAME);
        this.registerLocalChildren();
    }

    private void registerLocalChildren() {
        this.registerChild(CHILD_PROFILER_TILEDVIEW, ProfilerTiledView.class);
        this.registerChild(CHILD_JVMOPTION, TextField.class);
        this.registerChild(CHILD_DELETE, Button.class);
    }

    protected View createChild(String string) {
        if (string.equals(CHILD_PROFILER_TILEDVIEW)) {
            return new ProfilerTiledView((View)this, CHILD_PROFILER_TILEDVIEW, this.getRequestContext());
        }
        if (string.equals(CHILD_JVMOPTION)) {
            return new TextField((ContainerView)this, CHILD_JVMOPTION, (Object)"");
        }
        if (string.equals(CHILD_DELETE)) {
            return new Button((ContainerView)this, CHILD_DELETE, (Object)"");
        }
        return super.createChild(string);
    }

    public void beginDisplay(DisplayEvent displayEvent) throws ModelControlException {
        super.beginDisplay(displayEvent);
        this.setDisplayFieldValue(CHILD_JVMOPTION, "");
    }

    public String getDefaultURL() {
        return "Profiler.jsp";
    }

    public ServerComponent getServerComponent() throws Exception {
        return this.getInstance().getJVMComponent().getProfiler();
    }

    protected String[] getConfigNames() {
        return configName;
    }

    protected String getPageName() {
        return PAGE_NAME;
    }

    protected String[] getDisplayNames() {
        return name;
    }

    protected short[] getTypes() {
        return type;
    }

    public void preSave() throws Exception {
        ArrayList arrayList = this.getJVMOptionsList();
        JVMComponentBean jVMComponentBean = this.getInstance().getJVMComponent();
        if (jVMComponentBean.isProfilerExists()) {
            jVMComponentBean.deleteProfiler();
        }
        jVMComponentBean.createProfiler(this.getDisplayFieldStringValue(name[0]));
        Profiler profiler = jVMComponentBean.getProfiler(this.getDisplayFieldStringValue(name[0]));
        this.setProfilerJvmOptions(arrayList);
    }

    public ProfilerTiledView getProfilerTiledView() {
        return (ProfilerTiledView)this.getChild(CHILD_PROFILER_TILEDVIEW);
    }

    private void setProfilerJvmOptions(ArrayList arrayList) throws Exception {
        String string = this.getDisplayFieldStringValue(CHILD_JVMOPTION);
        Profiler profiler = this.getInstance().getJVMComponent().getProfiler();
        if (!string.equals("")) {
            arrayList.add(string);
        }
        if (arrayList.size() > 0) {
            profiler.setJvmOptions(arrayList.toArray(new String[0]));
        }
    }

    public void handleDeleteRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        this.getProfilerTiledView().deleteAction(requestInvocationEvent);
        this.forwardTo();
    }

    private ArrayList getJVMOptionsList() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        Profiler profiler = this.getInstance().getJVMComponent().getProfiler();
        if (profiler == null) {
            return arrayList;
        }
        String[] stringArray = profiler.getJvmOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public boolean beginEmptyTableDisplay(ChildDisplayEvent childDisplayEvent) throws Exception {
        JVMComponentBean jVMComponentBean = this.getInstance().getJVMComponent();
        if (jVMComponentBean.isProfilerExists()) {
            Profiler profiler = jVMComponentBean.getProfiler();
            if (profiler == null) {
                return true;
            }
            String[] stringArray = profiler.getJvmOptions();
            return stringArray == null || stringArray.length < 1;
        }
        return true;
    }
}

