/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.gui.jato;

import com.iplanet.ias.admin.common.exception.AFRuntimeStoreException;
import com.iplanet.ias.admin.server.gui.jato.BasicViewBeanBase;
import com.iplanet.ias.admin.server.gui.jato.ErrorHandlerViewBean;
import com.iplanet.ias.admin.server.gui.jato.IndexTreeModel;
import com.iplanet.ias.admin.server.gui.jato.IndexTreeModelImpl;
import com.iplanet.ias.admin.server.gui.jato.IndexTreeNode;
import com.iplanet.ias.admin.server.gui.jato.InstanceNotFoundException;
import com.iplanet.ias.admin.server.gui.jato.InstanceRootNode;
import com.iplanet.ias.admin.server.gui.jato.JatoServletBase;
import com.iplanet.ias.admin.server.gui.jato.NodeNotFoundException;
import com.iplanet.ias.admin.servermodel.ServerInstanceManagerFactory;
import com.iplanet.ias.admin.util.Logger;
import com.iplanet.ias.license.IASLicense;
import com.iplanet.ias.util.ASThreadLocal;
import com.iplanet.jato.CompleteRequestException;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestContextImpl;
import com.iplanet.jato.ViewBeanManager;
import com.iplanet.jato.util.WrapperRuntimeException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.util.Base64;

public class Module1Servlet
extends JatoServletBase {
    public static final String DEFAULT_MODULE_URL = "../module1";
    public static String PACKAGE_NAME = Module1Servlet.getPackageName((String)Module1Servlet.class.getName());

    protected void checkLicense(RequestContext requestContext) throws ServletException {
        HttpServletRequest httpServletRequest = requestContext.getRequest();
        String string = httpServletRequest.getRemoteAddr();
        try {
            IASLicense.checkAllowRemoteAdmin((String)string);
        }
        catch (Exception exception) {
            System.out.println("Remote Admin not allowed with current License. Requestor-IP=" + string);
            try {
                String string2 = BasicViewBeanBase.getLocalizedHTML(requestContext, "/noLicense.html");
                requestContext.getResponse().sendRedirect(".." + string2);
            }
            catch (IOException iOException) {
                System.out.println("forward exception (IO):" + iOException.getMessage());
            }
            catch (IllegalStateException illegalStateException) {
                System.out.println("forward exception (state):" + illegalStateException.getMessage());
            }
            throw new CompleteRequestException();
        }
    }

    protected void onBeforeRequest(RequestContext requestContext) throws ServletException {
        String string;
        this.checkLicense(requestContext);
        HttpServletRequest httpServletRequest = requestContext.getRequest();
        ASThreadLocal.addRequestParam((String)ASThreadLocal.REMOTE_HOST, (String)httpServletRequest.getRemoteAddr());
        ASThreadLocal.addRequestParam((String)ASThreadLocal.ACCESS_MODE, (String)ASThreadLocal.ACCESS_MODE_WEB);
        String string2 = httpServletRequest.getHeader("authorization");
        String string3 = this.decodeUserName(string2);
        ASThreadLocal.addRequestParam((String)ASThreadLocal.AUTH_USER, (String)string3);
        String string4 = httpServletRequest.getParameter("page");
        if (string4 == null) {
            string4 = this.parsePathInfo(httpServletRequest.getPathInfo());
        }
        if (string4.equals("Login") || string4.equals("TopFrameset")) {
            return;
        }
        HttpSession httpSession = httpServletRequest.getSession(true);
        if (httpSession != null && (string = (String)httpSession.getAttribute("iASAdminUserName")) != null) {
            return;
        }
        try {
            string = BasicViewBeanBase.getLocalizedHTML(requestContext, "/redirect.html");
            requestContext.getResponse().sendRedirect(".." + string);
        }
        catch (IOException iOException) {
            System.out.println("forward exception (IO):" + iOException.getMessage());
        }
        catch (IllegalStateException illegalStateException) {
            System.out.println("forward exception (state):" + illegalStateException.getMessage());
        }
        throw new CompleteRequestException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAfterRequest(RequestContext requestContext) {
        try {
            String string;
            HttpSession httpSession = requestContext.getRequest().getSession(false);
            if (httpSession != null && (string = (String)httpSession.getAttribute("ShutDownInProgress")) != null) {
                httpSession.removeAttribute("ShutDownInProgress");
                ServerInstanceManagerFactory serverInstanceManagerFactory = ServerInstanceManagerFactory.getFactory();
                try {
                    serverInstanceManagerFactory.getServerInstanceManager().stopServer();
                }
                catch (Exception exception) {
                    Logger.log((String)exception.getMessage());
                }
            }
        }
        finally {
            ASThreadLocal.removeRequestParam((String)ASThreadLocal.REMOTE_HOST);
            ASThreadLocal.removeRequestParam((String)ASThreadLocal.ACCESS_MODE);
            ASThreadLocal.removeRequestParam((String)ASThreadLocal.AUTH_USER);
        }
    }

    protected void onSessionTimeout(RequestContext requestContext) throws ServletException {
        try {
            String string = BasicViewBeanBase.getLocalizedHTML(requestContext, "/index.html");
            requestContext.getResponse().sendRedirect(".." + string);
        }
        catch (IOException iOException) {
            System.out.println("forward exception (IO):" + iOException.getMessage());
        }
        catch (IllegalStateException illegalStateException) {
            System.out.println("forward exception (state):" + illegalStateException.getMessage());
        }
        throw new CompleteRequestException();
    }

    protected void initializeRequestContext(RequestContext requestContext) {
        super.initializeRequestContext(requestContext);
        ViewBeanManager viewBeanManager = new ViewBeanManager(requestContext, PACKAGE_NAME);
        ((RequestContextImpl)requestContext).setViewBeanManager(viewBeanManager);
    }

    public String getModuleURL() {
        String string = super.getModuleURL();
        if (string != null) {
            return string;
        }
        return DEFAULT_MODULE_URL;
    }

    protected void onUncaughtException(RequestContext requestContext, Exception exception) throws ServletException, IOException {
        Object object;
        if (exception instanceof WrapperRuntimeException) {
            object = (WrapperRuntimeException)exception;
            if (object.getRootCause() instanceof AFRuntimeStoreException) {
                String string = BasicViewBeanBase.getLocalizedHTML(requestContext, "/html/redirect.html");
                requestContext.getResponse().sendRedirect(".." + string);
                return;
            }
            if (object.getRootCause() instanceof InstanceNotFoundException) {
                IndexTreeModel indexTreeModel = IndexTreeModelImpl.getIndexTreeModel(requestContext);
                InstanceRootNode instanceRootNode = indexTreeModel.getInstanceRoot();
                if (instanceRootNode != null) {
                    try {
                        ((IndexTreeNode)instanceRootNode).setIsExpanded(false);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                String string = BasicViewBeanBase.getLocalizedHTML(requestContext, "/html/TopFrameset.html");
                requestContext.getResponse().sendRedirect(".." + string);
                return;
            }
            if (object.getRootCause() instanceof NodeNotFoundException) {
                String string = BasicViewBeanBase.getLocalizedHTML(requestContext, "/html/TopFrameset.html");
                requestContext.getResponse().sendRedirect(".." + string);
                return;
            }
        }
        if (exception instanceof NodeNotFoundException) {
            object = BasicViewBeanBase.getLocalizedHTML(requestContext, "/html/TopFrameset.html");
            requestContext.getResponse().sendRedirect(".." + (String)object);
            return;
        }
        if (exception instanceof AFRuntimeStoreException) {
            object = BasicViewBeanBase.getLocalizedHTML(requestContext, "/html/redirect.html");
            requestContext.getResponse().sendRedirect(".." + (String)object);
            return;
        }
        object = requestContext.getViewBeanManager();
        try {
            ErrorHandlerViewBean errorHandlerViewBean = (ErrorHandlerViewBean)object.getViewBean("com.iplanet.ias.admin.server.gui.jato.ErrorHandlerViewBean");
            errorHandlerViewBean.setException(exception);
            errorHandlerViewBean.forwardTo(requestContext);
        }
        catch (Exception exception2) {
            super.onUncaughtException(requestContext, exception);
        }
    }

    private String decodeUserName(String string) {
        String string2 = this.parseUsername(string);
        return string2;
    }

    protected String parseUsername(String string) {
        Base64 base64 = new Base64();
        if (string == null) {
            return null;
        }
        if (!string.toLowerCase().startsWith("basic ")) {
            return null;
        }
        string = string.substring(6).trim();
        String string2 = new String(Base64.decode((byte[])string.getBytes()));
        int n = string2.indexOf(58);
        if (n < 0) {
            return null;
        }
        String string3 = string2.substring(0, n).trim();
        return string3;
    }
}

