/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.gui.jato;

import com.iplanet.ias.admin.common.exception.AFRuntimeStoreException;
import com.iplanet.ias.admin.server.gui.jato.BasicViewBeanBase;
import com.iplanet.ias.admin.server.gui.jato.BooleanCheckBox;
import com.iplanet.ias.admin.server.gui.jato.IndexTreeModel;
import com.iplanet.ias.admin.server.gui.jato.IndexTreeModelImpl;
import com.iplanet.ias.admin.server.gui.jato.IndexTreeNode;
import com.iplanet.ias.admin.server.gui.jato.InstanceNode;
import com.iplanet.ias.admin.server.gui.jato.InstanceSettingsViewBean;
import com.iplanet.ias.admin.server.gui.jato.ServerInstancesViewBean;
import com.iplanet.ias.admin.server.gui.util.ResponseBean;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.ServerInstanceManagerFactory;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.HREF;
import com.iplanet.jato.view.html.StaticTextField;
import com.iplanet.jato.view.html.TextField;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class InstanceIndexViewBean
extends BasicViewBeanBase {
    public static final String PAGE_NAME = "InstanceIndex";
    public static final String DEFAULT_DISPLAY_JSP = "InstanceIndex.jsp";
    public static final String CHILD_START = "start";
    public static final String CHILD_STOP = "stop";
    public static final String CHILD_RESTART = "restart";
    public static final String CHILD_REMOVE = "remove";
    public static final String CHILD_DEPLOY = "deploy";
    public static final String CHILD_APPLYCHANGES = "reconfigure";
    public static final String CHILD_MANAGE = "manage";
    public static final String CHILD_PORT = "port";
    public static final String CHILD_STATUS = "status";
    public static final String CHILD_HOST = "host";
    public static final String CHILD_MESSAGE = "statusMessage";
    public static final String CHILD_LOCATION = "location";
    public static final String CHILD_DEBUG = "startdebug";
    public static final String CHILD_VERSION = "version";
    public static final String CHILD_CONFIGACTIONMESSAGE = "configmessage";
    public static final String CHILD_SETTINGS = "settings";
    public static final String CHILD_DEBUGENABLED = "debugEnabled";
    private boolean isApplyNeeded = false;
    private boolean isRestartNeeded = false;
    private String configMessage;

    public InstanceIndexViewBean(RequestContext requestContext) {
        super(requestContext, PAGE_NAME);
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_JSP);
        this.registerChildren();
    }

    protected void registerChildren() {
        this.registerChild(CHILD_START, HREF.class);
        this.registerChild(CHILD_DEBUG, HREF.class);
        this.registerChild(CHILD_STOP, HREF.class);
        this.registerChild(CHILD_RESTART, HREF.class);
        this.registerChild(CHILD_REMOVE, HREF.class);
        this.registerChild(CHILD_SETTINGS, HREF.class);
        this.registerChild(CHILD_APPLYCHANGES, HREF.class);
        this.registerChild("InstanceName", TextField.class);
        this.registerChild(CHILD_HOST, StaticTextField.class);
        this.registerChild(CHILD_VERSION, StaticTextField.class);
        this.registerChild(CHILD_PORT, StaticTextField.class);
        this.registerChild(CHILD_LOCATION, StaticTextField.class);
        this.registerChild(CHILD_STATUS, StaticTextField.class);
        this.registerChild(CHILD_CONFIGACTIONMESSAGE, StaticTextField.class);
        this.registerChild(CHILD_DEBUGENABLED, BooleanCheckBox.class);
    }

    protected View createChild(String string) {
        try {
            return super.createChild(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (string.equals(CHILD_START) || string.equals(CHILD_DEBUG) || string.equals(CHILD_SETTINGS) || string.equals(CHILD_STOP) || string.equals(CHILD_RESTART) || string.equals(CHILD_REMOVE) || string.equals(CHILD_APPLYCHANGES)) {
                return new HREF((ContainerView)this, string, (Object)"");
            }
            if (string.equals(CHILD_VERSION) || string.equals(CHILD_HOST) || string.equals(CHILD_LOCATION) || string.equals(CHILD_STATUS) || string.equals(CHILD_MESSAGE) || string.equals(CHILD_CONFIGACTIONMESSAGE)) {
                return new StaticTextField((ContainerView)this, string, (Object)"");
            }
            if (string.equals("InstanceName")) {
                return new StaticTextField((ContainerView)this, "InstanceName", (Object)this.getInstanceName());
            }
            if (string.equals(CHILD_PORT)) {
                return new StaticTextField((ContainerView)this, CHILD_PORT, (Object)"");
            }
            if (string.equals(CHILD_DEBUGENABLED)) {
                return new BooleanCheckBox((ContainerView)this, CHILD_DEBUGENABLED, new Boolean(false));
            }
            throw new IllegalArgumentException("Invalid child name \"" + string + "\"");
        }
    }

    private String getPathSeparator(String string) {
        String string2 = "";
        String string3 = File.separator;
        if (string != null) {
            string2 = string3.equals("/") ? string.replace('\\', '/') : string.replace('/', '\\');
        }
        return string2;
    }

    public void handleStartRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        try {
            HttpServletRequest httpServletRequest = requestInvocationEvent.getRequestContext().getRequest();
            String string = httpServletRequest.getParameter("DebugMode");
            if (this.getInstance().getSecurityPasswordTokens() != null) {
                ViewBean viewBean = this.getViewBean("SecureStart");
                viewBean.setDisplayFieldValue("DebugStart", (Object)string);
                viewBean.forwardTo(this.getRequestContext());
                return;
            }
            if (string.equals("true")) {
                this.handleStartdebugRequest(requestInvocationEvent);
            } else {
                this.getInstance().start();
                this.setInfoMessage(InstanceIndexViewBean.getLocalizedString("MSG_ServerStarted"));
                this.forwardTo(requestInvocationEvent.getRequestContext());
            }
        }
        catch (AFRuntimeStoreException aFRuntimeStoreException) {
            throw aFRuntimeStoreException;
        }
        catch (Exception exception) {
            this.handleError(requestInvocationEvent, exception.getMessage());
        }
    }

    public void handleSettingsRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        ViewBean viewBean = this.getViewBean(InstanceSettingsViewBean.class);
        viewBean.forwardTo(this.rc);
    }

    public void handleStartdebugRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.rc.getRequest().getSession().getAttribute("selectedNode");
        if (indexTreeNode instanceof InstanceNode) {
            ((InstanceNode)indexTreeNode).setForceUpdate();
        }
        try {
            this.getInstance().startInDebugMode();
            this.setInfoMessage(InstanceIndexViewBean.getLocalizedString("MSG_ServerStartedDebug"));
            this.forwardTo(requestInvocationEvent.getRequestContext());
        }
        catch (AFRuntimeStoreException aFRuntimeStoreException) {
            throw aFRuntimeStoreException;
        }
        catch (Exception exception) {
            this.handleError(requestInvocationEvent, exception.getMessage());
        }
    }

    public void handleStopRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.rc.getRequest().getSession().getAttribute("selectedNode");
        if (indexTreeNode instanceof InstanceNode) {
            ((InstanceNode)indexTreeNode).setForceUpdate();
        }
        try {
            this.getInstance().stop();
            this.setInfoMessage(InstanceIndexViewBean.getLocalizedString("MSG_ServerStopped"));
            this.forwardTo(requestInvocationEvent.getRequestContext());
        }
        catch (AFRuntimeStoreException aFRuntimeStoreException) {
            throw aFRuntimeStoreException;
        }
        catch (Exception exception) {
            this.handleError(requestInvocationEvent, exception.getMessage());
        }
    }

    public void handleReconfigureRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.rc.getRequest().getSession().getAttribute("selectedNode");
        if (indexTreeNode instanceof InstanceNode) {
            ((InstanceNode)indexTreeNode).setForceUpdate();
        }
        try {
            boolean bl = this.getInstance().applyChanges();
            this.setInfoMessage(InstanceIndexViewBean.getLocalizedString("MSG_ServerReconfig"));
            this.forwardTo(requestInvocationEvent.getRequestContext());
        }
        catch (AFRuntimeStoreException aFRuntimeStoreException) {
            throw aFRuntimeStoreException;
        }
        catch (Exception exception) {
            this.handleError(requestInvocationEvent, exception.getMessage());
        }
    }

    public void handleRestartRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.rc.getRequest().getSession().getAttribute("selectedNode");
        if (indexTreeNode instanceof InstanceNode) {
            ((InstanceNode)indexTreeNode).setForceUpdate();
        }
        try {
            this.getInstance().restart();
            this.setInfoMessage(InstanceIndexViewBean.getLocalizedString("MSG_ServerRestarted"));
            this.forwardTo(requestInvocationEvent.getRequestContext());
        }
        catch (AFRuntimeStoreException aFRuntimeStoreException) {
            throw aFRuntimeStoreException;
        }
        catch (Exception exception) {
            this.handleError(requestInvocationEvent, exception.getMessage());
        }
    }

    public void handleRemoveRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        ServerInstanceManager serverInstanceManager = ServerInstanceManagerFactory.getFactory().getServerInstanceManager();
        try {
            ServerInstancesViewBean serverInstancesViewBean = (ServerInstancesViewBean)this.getViewBean(ServerInstancesViewBean.class);
            serverInstancesViewBean.setTreeRefresh(true);
            serverInstanceManager.deleteServerInstance(this.getInstanceName());
            IndexTreeModel indexTreeModel = IndexTreeModelImpl.getIndexTreeModel(this.getRequestContext());
            indexTreeModel.getInstanceRoot().refreshServerInstances();
            String string = BasicViewBeanBase.getLocalizedHTML(this.rc, "/html/TopFrameset.html");
            this.getRequestContext().getResponse().sendRedirect(".." + string);
        }
        catch (Exception exception) {
            ResponseBean.sendResponse(exception.getMessage(), PAGE_NAME, this.getRequestContext());
        }
    }

    public void beginDisplay(DisplayEvent displayEvent) throws ModelControlException {
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.rc.getRequest().getSession().getAttribute("selectedNode");
        if (indexTreeNode instanceof InstanceNode) {
            ((InstanceNode)indexTreeNode).setForceUpdate();
        }
        super.beginDisplay(displayEvent);
        if (indexTreeNode instanceof InstanceNode) {
            InstanceNode instanceNode = (InstanceNode)indexTreeNode;
            this.isApplyNeeded = instanceNode.isApplyNeeded();
            this.isRestartNeeded = instanceNode.isRestartNeeded();
            if (this.isApplyNeeded && this.isRestartNeeded) {
                this.configMessage = beforeWarningHeading + InstanceIndexViewBean.getLocalizedString("MSG_NeedApplyChangesAndRestartHeading") + "</div> <div class='alert-message-text'>" + InstanceIndexViewBean.getLocalizedString("MSG_NeedApplyChangesAndRestart") + "</div></td></tr></table></td></tr></table>";
            } else if (this.isApplyNeeded) {
                this.configMessage = beforeWarningHeading + InstanceIndexViewBean.getLocalizedString("MSG_NeedApplyChangesHeading") + "</div> <div class='alert-message-text'>" + InstanceIndexViewBean.getLocalizedString("MSG_NeedApplyChanges") + "</div></td></tr></table></td></tr></table>";
            } else if (this.isRestartNeeded) {
                this.configMessage = beforeWarningHeading + InstanceIndexViewBean.getLocalizedString("MSG_NeedRestartHeading") + "</div> <div class='alert-message-text'>" + InstanceIndexViewBean.getLocalizedString("MSG_NeedRestart") + "</div></td></tr></table></td></tr></table>";
            }
            try {
                Boolean bl;
                boolean bl2 = this.getInstance().isRunning();
                if (bl2) {
                    this.setDisplayFieldValue(CHILD_STATUS, InstanceIndexViewBean.getLocalizedString("MSG_Running"));
                    bl = (Boolean)this.getInstance().getJVMComponent().getAttribute(CHILD_DEBUGENABLED);
                } else {
                    this.setDisplayFieldValue(CHILD_STATUS, InstanceIndexViewBean.getLocalizedString("MSG_NotRunning"));
                    bl = new Boolean(false);
                }
                BooleanCheckBox booleanCheckBox = (BooleanCheckBox)this.getChild(CHILD_DEBUGENABLED);
                booleanCheckBox.setChecked(bl);
                ServerInstanceManagerFactory serverInstanceManagerFactory = ServerInstanceManagerFactory.getFactory();
                this.setDisplayFieldValue(CHILD_VERSION, serverInstanceManagerFactory.getServerInstanceManager().getVersion());
                this.setDisplayFieldValue(CHILD_HOST, this.getInstance().getHostAndPort().getHost());
                InstanceEnvironment instanceEnvironment = new InstanceEnvironment(this.getInstance().getName());
                String string = this.getPathSeparator(instanceEnvironment.getInstanceDirPath());
                this.setDisplayFieldValue(CHILD_LOCATION, string);
                String string2 = "";
                try {
                    ServerModelIterator serverModelIterator = this.getInstance().getHttpService().getHttpListeners();
                    while (serverModelIterator.hasNext()) {
                        if (!string2.equals("")) {
                            string2 = string2 + ", ";
                        }
                        string2 = string2 + ((ServerComponent)serverModelIterator.next()).getAttribute(CHILD_PORT);
                    }
                }
                catch (Exception exception) {
                    string2 = String.valueOf(this.getInstance().getHostAndPort().getPort());
                }
                this.setDisplayFieldValue(CHILD_PORT, string2);
            }
            catch (AFRuntimeStoreException aFRuntimeStoreException) {
                throw aFRuntimeStoreException;
            }
            catch (Exception exception) {
                this.setErrorMessage(exception.getMessage());
            }
        } else {
            System.out.println("Instance Node is not selected Node!!!");
        }
    }

    public boolean beginConfigActionNeededDisplay(ChildDisplayEvent childDisplayEvent) throws ModelControlException {
        return this.configMessage != null;
    }

    public String endConfigActionNeededDisplay(ChildContentDisplayEvent childContentDisplayEvent) {
        return this.configMessage;
    }
}

