/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.gui.jato;

import com.iplanet.ias.admin.server.gui.jato.AdminTreeNode;
import com.iplanet.ias.admin.server.gui.jato.BasicViewBeanBase;
import com.iplanet.ias.admin.server.gui.jato.I18NResourceBundleModel;
import com.iplanet.ias.admin.server.gui.jato.IndexTreeModel;
import com.iplanet.ias.admin.server.gui.jato.IndexTreeNode;
import com.iplanet.ias.admin.server.gui.jato.InstanceNode;
import com.iplanet.ias.admin.server.gui.jato.InstanceRootNode;
import com.iplanet.ias.admin.server.gui.jato.NodeNotFoundException;
import com.iplanet.ias.admin.server.gui.jato.ServerInstancesViewBean;
import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.ServerInstanceManagerFactory;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.jato.ModelManager;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.TreeModelBase;
import com.iplanet.jato.model.ValidationException;
import com.iplanet.jato.util.StringTokenizer2;

public class IndexTreeModelImpl
extends TreeModelBase
implements IndexTreeModel {
    private boolean initialExpand = true;
    private String name;
    private int index = 0;
    private InstanceRootNode instanceRoot = null;
    private AdminTreeNode adminRoot = null;
    private IndexTreeNode root = null;

    public static IndexTreeModel getIndexTreeModel(RequestContext requestContext) {
        ModelManager modelManager = requestContext.getModelManager();
        IndexTreeModelImpl indexTreeModelImpl = (IndexTreeModelImpl)modelManager.getModel(IndexTreeModel.class, modelManager.getDefaultModelInstanceName(IndexTreeModel.class), true, true);
        if (indexTreeModelImpl.initialExpand) {
            requestContext.getRequest().getSession().setAttribute("selectedNode", (Object)indexTreeModelImpl.getInstanceRoot());
        }
        return indexTreeModelImpl;
    }

    public IndexTreeModelImpl() {
        this.createIndexData();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void root() throws ModelControlException {
        this.setCurrentNode(this.root);
        this.setNodeLevel(0);
        this.setIterationComplete(false);
    }

    public String getNodeName() throws ModelControlException {
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.getCurrentNode();
        if (indexTreeNode != null) {
            return indexTreeNode.getName();
        }
        return null;
    }

    public void updateInstanceStatus() {
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.getCurrentNode();
        if (indexTreeNode != null) {
            indexTreeNode.updateInstanceStatus();
        }
    }

    public String getNodeType() throws ModelControlException {
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.getCurrentNode();
        if (indexTreeNode != null) {
            return indexTreeNode.getType();
        }
        return null;
    }

    public IndexTreeNode getNode(String string) throws NodeNotFoundException {
        String[] stringArray = StringTokenizer2.tokenize((String)string, (String)".");
        IndexTreeNode indexTreeNode = this.root;
        block0: for (int i = 1; i < stringArray.length; ++i) {
            for (int j = 0; j < indexTreeNode.getChildren().size(); ++j) {
                IndexTreeNode indexTreeNode2 = (IndexTreeNode)indexTreeNode.getChildren().get(j);
                if (!String.valueOf(indexTreeNode2.getID()).equals(stringArray[i])) continue;
                indexTreeNode = indexTreeNode2;
                continue block0;
            }
        }
        if (!indexTreeNode.getPath().equals(string)) {
            throw new NodeNotFoundException("Incorrect node (" + indexTreeNode.getPath() + " != " + string + ")");
        }
        return indexTreeNode;
    }

    public void beforeRoot() throws ModelControlException {
        this.setCurrentNode(null);
        this.setNodeLevel(-1);
        this.setIterationComplete(false);
    }

    public Object getCurrentNode() {
        return super.getCurrentNode();
    }

    public void setCurrentNode(String string) throws ModelControlException, NodeNotFoundException {
        this.setCurrentNode(this.getNode(string));
    }

    public String getNodeID() {
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.getCurrentNode();
        if (indexTreeNode != null) {
            return indexTreeNode.getPath();
        }
        return null;
    }

    public String getNodeHID() {
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.getCurrentNode();
        if (indexTreeNode != null) {
            return indexTreeNode.getHighlightID();
        }
        return "0";
    }

    public String getIconName(boolean bl) {
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.getCurrentNode();
        if (indexTreeNode != null) {
            return indexTreeNode.getIconName(bl);
        }
        return "props.gif";
    }

    public boolean isParentNode() {
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.getCurrentNode();
        if (indexTreeNode != null) {
            return indexTreeNode.getChildren().size() > 0;
        }
        return false;
    }

    public boolean isChildNode() {
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.getCurrentNode();
        if (indexTreeNode != null) {
            return indexTreeNode.getParent() != null;
        }
        return false;
    }

    public boolean firstChild() throws ModelControlException {
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.getCurrentNode();
        if (indexTreeNode != null && this.isParentNode()) {
            this.setCurrentNode(indexTreeNode.getChildren().get(0));
            this.incrementNodeLevel();
            return true;
        }
        return false;
    }

    public boolean parent() throws ModelControlException {
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.getCurrentNode();
        if (indexTreeNode != null && this.isChildNode()) {
            this.setCurrentNode(indexTreeNode.getParent());
            this.decrementNodeLevel();
            return true;
        }
        return false;
    }

    public boolean nextSibling() throws ModelControlException {
        IndexTreeNode indexTreeNode = (IndexTreeNode)this.getCurrentNode();
        if (indexTreeNode != null) {
            IndexTreeNode indexTreeNode2 = indexTreeNode.getNextSibling();
            if (indexTreeNode2 != null) {
                this.setCurrentNode(indexTreeNode.getNextSibling());
                return true;
            }
            return false;
        }
        return false;
    }

    public Object getValue(String string) {
        Object[] objectArray = this.getValues(string);
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        return objectArray[0];
    }

    public void setValue(String string, Object object) throws ValidationException {
        this.setValues(string, new Object[]{object});
    }

    public Object[] getValues(String string) {
        if (this.getCurrentNode() != null) {
            return new Object[]{((IndexTreeNode)this.getCurrentNode()).getAttribute(string)};
        }
        return null;
    }

    public void setValues(String string, Object[] objectArray) throws ValidationException {
        if (this.getCurrentNode() != null) {
            ((IndexTreeNode)this.getCurrentNode()).setAttribute(string, objectArray);
        }
    }

    public IndexTreeNode addNode(IndexTreeNode indexTreeNode, String string, String string2) {
        IndexTreeNode indexTreeNode2 = new IndexTreeNode(indexTreeNode, string, string2, this.index++, this);
        return indexTreeNode2;
    }

    private void createIndexData() {
        try {
            this.root = new IndexTreeNode(null, "root", "root", this.index++, this);
            this.adminRoot = new AdminTreeNode(this.root, this.index++, this);
            this.adminRoot.updateInstanceStatus();
            this.adminRoot.hasInstanceStatusChanged();
            String string = I18NResourceBundleModel.getLocalizedString("NODE_ServerInstances");
            this.instanceRoot = new InstanceRootNode(this.root, "container", string, this.index++, this);
            this.instanceRoot.setViewBeanClass(ServerInstancesViewBean.class.getName());
            ServerInstanceManager serverInstanceManager = ServerInstanceManagerFactory.getFactory().getServerInstanceManager();
            ServerModelIterator serverModelIterator = serverInstanceManager.getAllServerInstances();
            while (serverModelIterator.hasNext()) {
                AppServerInstance appServerInstance = (AppServerInstance)serverModelIterator.next();
                this.addInstance(appServerInstance);
            }
        }
        catch (Exception exception) {
            BasicViewBeanBase.log(exception);
        }
    }

    public void addInstance(AppServerInstance appServerInstance) {
        InstanceNode instanceNode = new InstanceNode(this.instanceRoot, appServerInstance.getName(), this.index++, this);
        instanceNode.updateInstanceStatus();
        instanceNode.hasInstanceStatusChanged();
    }

    public void removeInstance(String string) {
        this.instanceRoot.removeChild(string);
    }

    public InstanceRootNode getInstanceRoot() {
        return this.instanceRoot;
    }

    public boolean isInitialExpand() {
        boolean bl = this.initialExpand;
        this.initialExpand = false;
        return bl;
    }
}

