/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.gui.jato;

import com.iplanet.ias.admin.common.JMSDestinationInfo;
import com.iplanet.ias.admin.common.exception.JMSAdminException;
import com.iplanet.ias.admin.server.gui.jato.BasicViewBeanBase;
import com.iplanet.ias.admin.server.gui.jato.I18NResourceBundleModel;
import com.iplanet.ias.admin.server.gui.jato.ImqDestinationsViewBean;
import com.iplanet.ias.admin.server.gui.util.ResponseBean;
import com.iplanet.ias.admin.servermodel.beans.JMSComponentBean;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.ComboBox;
import com.iplanet.jato.view.html.HiddenField;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.html.StaticTextField;
import com.iplanet.jato.view.html.TextField;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletException;

public class ImqDestinationViewBean
extends BasicViewBeanBase {
    public static final String PAGE_NAME = "ImqDestination";
    public static final String CHILD_SUBMIT = "Submit";
    public static final String CHILD_NAME = "Name";
    public static final String CHILD_TYPE = "Type";
    public static final String OPTION_CREATE = "create";
    public static final String OPTION_EDIT = "edit";
    protected static String HIDDEN = "Hidden";
    protected static String STATIC = "Static";
    public JMSComponentBean cb = null;

    public ImqDestinationViewBean(RequestContext requestContext) {
        super(requestContext, PAGE_NAME);
        this.setDefaultDisplayURL("EditImqDestination.jsp");
        this.cb = this.getInstance().getJMSComponent();
        this.registerOkCancel();
        this.registerSaveRevert();
        this.registerChildren();
    }

    protected void registerChildren() {
        this.registerChild(CHILD_NAME, TextField.class);
        this.registerChild(CHILD_TYPE, ComboBox.class);
        String string = this.getKeyAttribute();
        this.registerChild(string + HIDDEN, HiddenField.class);
        this.registerChild(CHILD_TYPE + HIDDEN, HiddenField.class);
        this.registerChild(string + STATIC, StaticTextField.class);
    }

    protected View createChild(String string) {
        try {
            return super.createChild(string);
        }
        catch (Exception exception) {
            if (string.equals(CHILD_NAME)) {
                TextField textField = new TextField((ContainerView)this, CHILD_NAME, (Object)"");
                return textField;
            }
            if (string.equals(CHILD_TYPE)) {
                ComboBox comboBox = new ComboBox((ContainerView)this, CHILD_TYPE, (Object)"");
                comboBox.setLabelForNoneSelected(I18NResourceBundleModel.getLocalizedString("MSG_None_Selected"));
                String[] stringArray = new String[]{"topic", "queue"};
                OptionList optionList = new OptionList(stringArray, stringArray);
                comboBox.setOptions(optionList);
                return comboBox;
            }
            if (string.endsWith(HIDDEN) || string.endsWith(STATIC)) {
                return new StaticTextField((ContainerView)this, string, (Object)"");
            }
            throw new IllegalArgumentException("Invalid child name [" + string + "]");
        }
    }

    public void handleOkRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        Properties properties = new Properties();
        try {
            this.cb.createDestination((String)this.getDisplayFieldValue(CHILD_NAME), (String)this.getDisplayFieldValue(CHILD_TYPE), properties);
        }
        catch (JMSAdminException jMSAdminException) {
            jMSAdminException.printStackTrace();
        }
        ViewBean viewBean = this.getViewBean(ImqDestinationsViewBean.class);
        viewBean.forwardTo(this.getRequestContext());
    }

    public void handleCancelRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        ViewBean viewBean = this.getViewBean(ImqDestinationsViewBean.class);
        viewBean.forwardTo(this.getRequestContext());
    }

    public void handleRevertRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        ViewBean viewBean = this.getViewBean(ImqDestinationViewBean.class);
        ((ImqDestinationViewBean)viewBean).setEditMode();
        viewBean.forwardTo(this.getRequestContext());
    }

    public void setCreateMode() {
        this.setDefaultDisplayURL("CreateImqDestination.jsp");
    }

    public void setEditMode() {
        this.setDefaultDisplayURL("EditImqDestination.jsp");
    }

    public TextField getDestinationName() {
        return (TextField)this.getChild(CHILD_NAME);
    }

    public boolean beginDestinationNameDisplay(ChildDisplayEvent childDisplayEvent) {
        return true;
    }

    private String getDestinationType(String string) {
        String string2 = null;
        JMSDestinationInfo[] jMSDestinationInfoArray = null;
        try {
            jMSDestinationInfoArray = this.cb.getAllDestinations(null);
        }
        catch (JMSAdminException jMSAdminException) {
            jMSAdminException.printStackTrace();
        }
        for (int i = 0; i < jMSDestinationInfoArray.length; ++i) {
            if (!jMSDestinationInfoArray[i].getDestinationName().equals(string)) continue;
            string2 = jMSDestinationInfoArray[i].getDestinationType();
            break;
        }
        return string2;
    }

    public void edit(Object object) {
        String string = this.getDestinationType((String)object);
        if (string == null) {
            return;
        }
        this.setDisplayFieldValue(CHILD_NAME, (String)object);
        this.setDisplayFieldValue(CHILD_TYPE, string);
        this.setDisplayFieldValue(this.getKeyAttribute() + HIDDEN, (String)object);
        this.setDisplayFieldValue(CHILD_TYPE + HIDDEN, string);
        this.setDisplayFieldValue(this.getKeyAttribute() + STATIC, (String)object);
        this.setEditMode();
    }

    public String getKeyAttribute() {
        return CHILD_NAME;
    }

    public void handleSaveRequest(RequestInvocationEvent requestInvocationEvent) throws ServletException, IOException {
        try {
            String string = this.getDisplayFieldStringValue(CHILD_NAME + HIDDEN);
            String string2 = this.getDisplayFieldStringValue(CHILD_TYPE);
            String string3 = (String)this.getDisplayFieldValue(CHILD_TYPE + HIDDEN);
            if (string3.equals(string2)) {
                return;
            }
            try {
                this.cb.destroyDestination(string, string3);
                Properties properties = new Properties();
                this.cb.createDestination(string, string2, properties);
            }
            catch (JMSAdminException jMSAdminException) {
                jMSAdminException.printStackTrace();
            }
            this.postSave();
        }
        catch (Exception exception) {
            ResponseBean.sendResponse(exception.getMessage(), PAGE_NAME, this.getRequestContext());
        }
    }

    protected void postSave() {
        ViewBean viewBean = this.getViewBean(ImqDestinationViewBean.class);
        ((ImqDestinationViewBean)viewBean).edit(this.getDisplayFieldValue(this.getKeyAttribute() + HIDDEN));
        viewBean.forwardTo(this.getRequestContext());
    }
}

